/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.component.menu;

import com.aetherteam.aether.client.gui.screen.menu.AetherTitleScreen;
import com.aetherteam.aether.mixin.mixins.client.accessor.ButtonAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AetherMenuButton
extends Button {
    private static final WidgetSprites AETHER_WIDGETS = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"title/button"), ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"title/button_highlighted"));
    private static final int BUTTON_WIDTH = 400;
    private static final int BUTTON_HEIGHT = 40;
    private static final int BUTTON_SEPARATION = 50;
    private static final int INITIAL_X_OFFSET = 16;
    private static final int INITIAL_Y_OFFSET = 100;
    private final AetherTitleScreen screen;
    public final int originalX;
    public final int originalY;
    public final int originalWidth;
    public final int originalHeight;
    public int hoverOffset;
    public int buttonCountOffset;
    public boolean serverButton;

    public AetherMenuButton(AetherTitleScreen screen, Button.Builder builder) {
        super(builder);
        this.screen = screen;
        this.originalX = this.getX();
        this.originalY = this.getY();
        this.originalWidth = this.getWidth();
        this.originalHeight = this.getHeight();
        this.hoverOffset = 0;
    }

    public AetherMenuButton(AetherTitleScreen screen, Button oldButton) {
        this(screen, new Button.Builder(oldButton.getMessage(), button -> oldButton.onPress()).bounds(oldButton.getX(), oldButton.getY(), oldButton.getWidth(), oldButton.getHeight()).createNarration(button -> ((ButtonAccessor)oldButton).callCreateNarrationMessage()));
        oldButton.visible = false;
        oldButton.active = false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        float scale = AetherTitleScreen.getScale(this.screen, minecraft);
        if (this.screen.isAlignedLeft()) {
            this.setX(16);
            this.setY((int)(100.0f / scale + (float)this.buttonCountOffset * (50.0f / scale)));
            this.setWidth((int)(400.0f / scale));
        } else {
            this.setX(this.originalX);
            this.setY((int)(10.0f + ((float)(this.height / 2) + 96.0f / scale) + 50.0f / scale * (float)this.buttonCountOffset));
            this.setWidth(this.originalWidth);
        }
        this.setHeight((int)(40.0f / scale));
        ResourceLocation location = AETHER_WIDGETS.get(this.isActive(), this.isHoveredOrFocused());
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        guiGraphics.blitSprite(location, this.getX() + this.hoverOffset, this.getY(), (int)(400.0f / scale), (int)(40.0f / scale));
        RenderSystem.disableBlend();
        poseStack.pushPose();
        float textScale = AetherMenuButton.getTextScale(this.screen, minecraft);
        float textX = (float)this.getX() + 35.0f * textScale + (float)this.hoverOffset;
        float textY = (float)this.getY() + ((float)this.height - 8.0f * textScale) / 2.0f;
        poseStack.translate(textX, textY, 0.0f);
        poseStack.scale(textScale, textScale, textScale);
        guiGraphics.drawString(font, this.getMessage(), 0, 0, this.getTextColor(mouseX, mouseY) | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        poseStack.popPose();
    }

    public static float getTextScale(AetherTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.getWindow().calculateScale(((Integer)minecraft.options.guiScale().get()).intValue(), minecraft.isEnforceUnicode());
        float elementScale = AetherTitleScreen.getScale(screen, minecraft);
        float elementPixelWidth = (int)((float)guiScale / elementScale);
        float textPixelWidth = elementPixelWidth + 2.0f;
        if (elementPixelWidth <= 1.0f) {
            textPixelWidth = 2.0f;
        }
        return textPixelWidth / (float)guiScale;
    }

    public int getTextColor(int mouseX, int mouseY) {
        if (!this.serverButton) {
            return this.isMouseOver(mouseX, mouseY) ? 11842776 : 0xD4D4D4;
        }
        return this.isMouseOver(mouseX, mouseY) ? 13746759 : 15457113;
    }

    public static int totalHeightRange(int buttonCount, float scale) {
        return (int)(100.0f / scale + (float)buttonCount * (60.0f / scale));
    }
}

