/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherMusicManager;
import com.aetherteam.aether.client.sound.FadeOutSoundInstance;
import com.aetherteam.aether.mixin.mixins.client.accessor.SoundEngineAccessor;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class AudioHooks {
    public static boolean shouldCancelMusic(SoundInstance sound) {
        if (Minecraft.getInstance().level != null && !((Boolean)AetherConfig.CLIENT.disable_music_manager.get()).booleanValue()) {
            Holder<SoundEvent> soundEvent = AudioHooks.getSoundEvent(sound);
            if (sound.getSource() == SoundSource.MUSIC && soundEvent != null && !soundEvent.is(AetherTags.SoundEvents.ACHIEVEMENT_SOUNDS)) {
                return AetherMusicManager.getSituationalMusic() != null && !sound.getLocation().equals((Object)SimpleSoundInstance.forMusic((SoundEvent)((SoundEvent)AetherMusicManager.getSituationalMusic().getEvent().value())).getLocation()) || AetherMusicManager.getCurrentMusic() != null && !sound.getLocation().equals((Object)AetherMusicManager.getCurrentMusic().getLocation());
            }
        }
        return false;
    }

    public static boolean preventAmbientPortalSound(SoundEngine soundEngine, SoundInstance sound) {
        Holder<SoundEvent> soundEvent;
        if (sound != null && (soundEvent = AudioHooks.getSoundEvent(sound)) != null && soundEvent.is(AetherTags.SoundEvents.AMBIENT_PORTAL_SOUNDS)) {
            return ((SoundEngineAccessor)soundEngine).aether$getInstanceToChannel().keySet().stream().anyMatch(playingInstance -> {
                Holder<SoundEvent> playingSound = AudioHooks.getSoundEvent(playingInstance);
                return playingSound != null && playingSound.is(AetherTags.SoundEvents.PORTAL_SOUNDS);
            });
        }
        return false;
    }

    public static void overrideActivatedPortalSound(SoundEngine soundEngine, SoundInstance sound) {
        Holder<SoundEvent> soundEvent;
        if (sound != null && (soundEvent = AudioHooks.getSoundEvent(sound)) != null && soundEvent.is(AetherTags.SoundEvents.ACTIVATED_PORTAL_SOUNDS)) {
            ((SoundEngineAccessor)soundEngine).aether$getInstanceToChannel().keySet().forEach(playingInstance -> {
                Holder<SoundEvent> playingSound = AudioHooks.getSoundEvent(playingInstance);
                if (playingSound != null && playingSound.is(AetherTags.SoundEvents.AMBIENT_PORTAL_SOUNDS) && playingInstance instanceof FadeOutSoundInstance) {
                    FadeOutSoundInstance fadeOutSoundInstance = (FadeOutSoundInstance)((Object)playingInstance);
                    fadeOutSoundInstance.fadeOut();
                }
            });
        }
    }

    private static Holder<SoundEvent> getSoundEvent(SoundInstance sound) {
        Optional optionalResourceKey;
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(sound.getLocation());
        if (soundEvent != null && (optionalResourceKey = BuiltInRegistries.SOUND_EVENT.getResourceKey((Object)soundEvent)).isPresent()) {
            return BuiltInRegistries.SOUND_EVENT.getHolderOrThrow((ResourceKey)optionalResourceKey.get());
        }
        return null;
    }

    public static void tick() {
        if (!((Boolean)AetherConfig.CLIENT.disable_music_manager.get()).booleanValue() && !Minecraft.getInstance().isPaused()) {
            AetherMusicManager.tick();
        }
    }

    public static void stop() {
        if (!((Boolean)AetherConfig.CLIENT.disable_music_manager.get()).booleanValue()) {
            AetherMusicManager.stopPlaying();
        }
    }
}

