/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.armor;

import com.gametechbc.traveloptics.api.item.AbstractImbuableArmorItem;
import com.gametechbc.traveloptics.item.TOArmorMaterials;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.entity.armor.ArchevokerArmorModel;
import io.redspace.ironsspellbooks.entity.armor.GenericCustomArmorRenderer;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class DeeplingMageArmorItem
extends AbstractImbuableArmorItem {
    public DeeplingMageArmorItem(ArmorItem.Type type, Item.Properties settings) {
        super((Holder<ArmorMaterial>)TOArmorMaterials.DEEPLING_MAGE, type, settings, new AttributeContainer((Holder)AttributeRegistry.SUMMON_DAMAGE, 0.025, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
    }

    @Override
    protected Set<ArmorItem.Type> getImbuableArmorTypes() {
        return Set.of(ArmorItem.Type.CHESTPLATE, ArmorItem.Type.HELMET);
    }

    @Override
    protected Map<ArmorItem.Type, Integer> getMaxSpellSlots() {
        return Map.of(ArmorItem.Type.CHESTPLATE, 1, ArmorItem.Type.HELMET, 1);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        super.inventoryTick(stack, level, entity, i, held);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide && this.isWearingFullSet(player) && player.isUnderWater()) {
                this.grantWaterBreathing(player);
            }
        }
    }

    private void grantWaterBreathing(Player player) {
        if (!player.hasEffect(MobEffects.WATER_BREATHING)) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0, false, false, true));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.translatable((String)"item.traveloptics.deepling_mage_armor.tooltip").withStyle(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)Component.translatable((String)"item.traveloptics.deepling_mage_armor.tooltip1"));
        tooltip.add((Component)Component.literal((String)""));
    }

    private boolean isWearingFullSet(Player player) {
        return player.getItemBySlot(ArmorItem.Type.HELMET.getSlot()).getItem() instanceof DeeplingMageArmorItem && player.getItemBySlot(ArmorItem.Type.CHESTPLATE.getSlot()).getItem() instanceof DeeplingMageArmorItem && player.getItemBySlot(ArmorItem.Type.LEGGINGS.getSlot()).getItem() instanceof DeeplingMageArmorItem && player.getItemBySlot(ArmorItem.Type.BOOTS.getSlot()).getItem() instanceof DeeplingMageArmorItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new GenericCustomArmorRenderer((GeoModel)new ArchevokerArmorModel());
    }
}

