/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.extended;

import com.gametechbc.traveloptics.config.SpellsConfig;
import com.gametechbc.traveloptics.init.TOSpells;
import com.github.L_Ender.cataclysm.blocks.EMP_Block;
import com.github.L_Ender.cataclysm.client.particle.Options.LightningParticleOptions;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.projectile.Death_Laser_Beam_Entity;
import com.github.L_Ender.cataclysm.init.ModBlocks;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ExtendedDeathLaserBeamEntity
extends Death_Laser_Beam_Entity {
    public ExtendedDeathLaserBeamEntity(EntityType<? extends Death_Laser_Beam_Entity> type, Level world) {
        super(type, world);
    }

    public ExtendedDeathLaserBeamEntity(EntityType<? extends Death_Laser_Beam_Entity> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration, float damage, float hpDamage) {
        super(type, world, caster, x, y, z, yaw, pitch, duration, damage, hpDamage);
    }

    public void tick() {
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.tickCount == 1 && this.level().isClientSide) {
            this.caster = (LivingEntity)this.level().getEntity(this.getCasterID());
        }
        if (!this.level().isClientSide && this.caster != null) {
            this.updateWithLivingEntity();
        }
        if (this.caster != null) {
            this.renderYaw = (float)(((double)this.caster.yHeadRot + 90.0) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-this.caster.getXRot()) * Math.PI / 180.0);
        }
        if (!this.on && this.appear.getTimer() == 0) {
            this.discard();
        }
        if (this.on && this.tickCount > 20) {
            this.appear.increaseTimer();
        } else {
            this.appear.decreaseTimer();
        }
        if (this.caster != null && !this.caster.isAlive()) {
            this.discard();
        }
        if (this.tickCount > 20) {
            this.updatedCalculateEndPos();
            List<LivingEntity> hit = this.updatedRaytraceEntities((Level)this.level(), (Vec3)new Vec3((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ), (boolean)false, (boolean)true, (boolean)true).entities;
            if (this.blockSide != null) {
                this.spawnUpdatedExplosionParticles(5);
                if (!this.level().isClientSide) {
                    BlockState block;
                    if (((Boolean)SpellsConfig.deathLaserBlockBreaking.get()).booleanValue()) {
                        for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)(this.collidePosX - 0.5)), (int)Mth.floor((double)(this.collidePosY - 0.5)), (int)Mth.floor((double)(this.collidePosZ - 0.5)), (int)Mth.floor((double)(this.collidePosX + 0.5)), (int)Mth.floor((double)(this.collidePosY + 0.5)), (int)Mth.floor((double)(this.collidePosZ + 0.5)))) {
                            block = this.level().getBlockState(pos);
                            if (block.isAir() || !block.is(ModTag.CM_GLASS) || !EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) continue;
                            this.level().destroyBlock(pos, true);
                        }
                    }
                    for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)(this.collidePosX - 2.5)), (int)Mth.floor((double)(this.collidePosY - 2.5)), (int)Mth.floor((double)(this.collidePosZ - 2.5)), (int)Mth.floor((double)(this.collidePosX + 2.5)), (int)Mth.floor((double)(this.collidePosY + 2.5)), (int)Mth.floor((double)(this.collidePosZ + 2.5)))) {
                        block = this.level().getBlockState(pos);
                        if (!block.is((Block)ModBlocks.EMP.get()) || ((Boolean)block.getValue((Property)EMP_Block.POWERED)).booleanValue() || !((Boolean)block.getValue((Property)EMP_Block.OVERLOAD)).booleanValue()) continue;
                        this.level().setBlockAndUpdate(pos, (BlockState)block.setValue((Property)EMP_Block.OVERLOAD, (Comparable)Boolean.valueOf(false)));
                    }
                    if (this.getFire()) {
                        BlockPos blockpos1 = BlockPos.containing((double)this.collidePosX, (double)this.collidePosY, (double)this.collidePosZ);
                        if (CMConfig.HarbingerLightFire) {
                            if (this.level().isEmptyBlock(blockpos1)) {
                                this.level().setBlockAndUpdate(blockpos1, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockpos1));
                            }
                        } else if (EventHooks.canEntityGrief((Level)this.level(), (Entity)this) && this.level().isEmptyBlock(blockpos1)) {
                            this.level().setBlockAndUpdate(blockpos1, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockpos1));
                        }
                    }
                }
            }
            if (!this.level().isClientSide) {
                for (LivingEntity target : hit) {
                    boolean flag;
                    if (((Boolean)SpellsConfig.deathLaserDealMagicDamage.get()).booleanValue()) {
                        if (this.caster == null || this.caster.isAlliedTo((Entity)target) || target == this.caster) continue;
                        flag = target.hurt(CMDamageTypes.causeDeathLaserDamage((Entity)this, (LivingEntity)this.caster), (float)((double)this.getDamage() + Math.min((double)this.getDamage(), (double)(target.getMaxHealth() * this.getHpDamage()) * 0.01)));
                        if (!this.getFire() || !flag) continue;
                        target.igniteForSeconds(5.0f);
                        continue;
                    }
                    if (this.caster == null || this.caster.isAlliedTo((Entity)target) || target == this.caster) continue;
                    flag = DamageSources.applyDamage((Entity)target, (float)((float)((double)this.getDamage() + Math.min((double)this.getDamage(), (double)(target.getMaxHealth() * this.getHpDamage()) * 0.01))), (DamageSource)TOSpells.DEATH_LASER_SPELL.get().getDamageSource((Entity)this, (Entity)this.caster));
                    if (!this.getFire() || !flag) continue;
                    target.igniteForSeconds(5.0f);
                }
            }
        }
        if (this.tickCount - 20 > this.getDuration()) {
            this.on = false;
        }
    }

    protected void spawnUpdatedExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 1.5f;
            float yaw = (float)((double)(this.random.nextFloat() * 2.0f) * Math.PI);
            float motionY = this.random.nextFloat() * 0.8f;
            float motionX = 1.5f * Mth.cos((float)yaw);
            float motionZ = 1.5f * Mth.sin((float)yaw);
            this.level().addParticle((ParticleOptions)new LightningParticleOptions(255, 26, 0), this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    private void updateWithLivingEntity() {
        this.setYaw((float)((double)(this.caster.yHeadRot + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.getXRot()) * Math.PI / 180.0));
        double eyeOffset = 0.06;
        this.setPos(this.caster.getX(), this.caster.getY() + (double)this.caster.getEyeHeight() - eyeOffset, this.caster.getZ());
    }

    private void updatedCalculateEndPos() {
        if (this.level().isClientSide()) {
            this.endPosX = this.getX() + 30.0 * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.getZ() + 30.0 * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.getY() + 30.0 * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.getX() + 30.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.getZ() + 30.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.getY() + 30.0 * Math.sin(this.getPitch());
        }
    }

    public DeathLaserbeamHitResult updatedRaytraceEntities(Level world, Vec3 from, Vec3 to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        DeathLaserbeamHitResult result = new DeathLaserbeamHitResult();
        result.setBlockHit((HitResult)world.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vec3 hitVec = result.blockHit.getLocation();
            this.collidePosX = hitVec.x;
            this.collidePosY = hitVec.y;
            this.collidePosZ = hitVec.z;
            this.blockSide = result.blockHit.getDirection();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.getEntitiesOfClass(LivingEntity.class, new AABB(Math.min(this.getX(), this.collidePosX), Math.min(this.getY(), this.collidePosY), Math.min(this.getZ(), this.collidePosZ), Math.max(this.getX(), this.collidePosX), Math.max(this.getY(), this.collidePosY), Math.max(this.getZ(), this.collidePosZ)).inflate(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.getPickRadius() + 0.5f;
            AABB aabb = entity.getBoundingBox().inflate((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.clip(from, to);
            if (aabb.contains(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public static class DeathLaserbeamHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

