/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.extended;

import com.gametechbc.traveloptics.config.SpellsConfig;
import com.gametechbc.traveloptics.init.TOSpells;
import com.github.L_Ender.cataclysm.client.particle.Options.LightningParticleOptions;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.Abyss_Blast_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ExtendedAbyssBlastEntity
extends Abyss_Blast_Entity {
    public ExtendedAbyssBlastEntity(EntityType<? extends Abyss_Blast_Entity> type, Level world) {
        super(type, world);
    }

    public ExtendedAbyssBlastEntity(EntityType<? extends Abyss_Blast_Entity> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration, float direction, float damage, float Hpdamage) {
        super(type, world, caster, x, y, z, yaw, pitch, duration, direction, damage, Hpdamage);
    }

    public void tick() {
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.tickCount == 1 && this.level().isClientSide) {
            this.caster = (LivingEntity)this.level().getEntity(this.getCasterID());
        }
        if (!this.level().isClientSide && this.caster != null) {
            this.updateWithLivingEntity();
        }
        if (this.caster != null) {
            this.renderYaw = (float)((double)(this.caster.yHeadRot + this.getBeamDirection()) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-this.caster.getXRot()) * Math.PI / 180.0);
        }
        if (!this.on && this.appear.getTimer() == 0) {
            this.discard();
        }
        if (this.on && this.tickCount > 20) {
            this.appear.increaseTimer();
        } else {
            this.appear.decreaseTimer();
        }
        if (this.caster != null && !this.caster.isAlive()) {
            this.discard();
        }
        if (this.tickCount > 20) {
            this.calculateUpdatedEndPos();
            List<LivingEntity> hit = this.updatedRaytraceEntities((Level)this.level(), (Vec3)new Vec3((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ)).entities;
            if (this.blockSide != null) {
                this.spawnUpdatedExplosionParticles(3);
                if (((Boolean)SpellsConfig.abyssalBlastBlockBreaking.get()).booleanValue() && !this.level().isClientSide) {
                    for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)(this.collidePosX - 0.5)), (int)Mth.floor((double)(this.collidePosY - 0.5)), (int)Mth.floor((double)(this.collidePosZ - 0.5)), (int)Mth.floor((double)(this.collidePosX + 0.5)), (int)Mth.floor((double)(this.collidePosY + 0.5)), (int)Mth.floor((double)(this.collidePosZ + 0.5)))) {
                        BlockState block = this.level().getBlockState(pos);
                        if (block.isAir() || block.is(ModTag.LEVIATHAN_IMMUNE) || !EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) continue;
                        this.level().destroyBlock(pos, false);
                    }
                }
            }
            if (!this.level().isClientSide) {
                for (LivingEntity target : hit) {
                    MobEffectInstance effectinstance;
                    int i;
                    MobEffectInstance effectinstance1;
                    boolean flag;
                    if (((Boolean)SpellsConfig.abyssalBlastDealMagicDamage.get()).booleanValue()) {
                        if (this.caster == null || this.caster.isAlliedTo((Entity)target) || target == this.caster || !(flag = target.hurt(CMDamageTypes.causeDeathLaserDamage((Entity)this, (LivingEntity)this.caster), (float)((double)this.getDamage() + Math.min((double)this.getDamage(), (double)(target.getMaxHealth() * this.getHpDamage()) * 0.01))))) continue;
                        effectinstance1 = target.getEffect((Holder)ModEffect.EFFECTABYSSAL_BURN);
                        i = 1;
                        if (effectinstance1 != null) {
                            i += effectinstance1.getAmplifier();
                            target.removeEffectNoUpdate((Holder)ModEffect.EFFECTABYSSAL_BURN);
                        } else {
                            --i;
                        }
                        i = Mth.clamp((int)i, (int)0, (int)3);
                        effectinstance = new MobEffectInstance((Holder)ModEffect.EFFECTABYSSAL_BURN, 160, i, false, true, true);
                        target.addEffect(effectinstance);
                        continue;
                    }
                    if (this.caster == null || this.caster.isAlliedTo((Entity)target) || target == this.caster || !(flag = DamageSources.applyDamage((Entity)target, (float)((float)((double)this.getDamage() + Math.min((double)this.getDamage(), (double)(target.getMaxHealth() * this.getHpDamage()) * 0.01))), (DamageSource)TOSpells.ABYSSAL_BLAST_SPELL.get().getDamageSource((Entity)this, (Entity)this.caster)))) continue;
                    effectinstance1 = target.getEffect((Holder)ModEffect.EFFECTABYSSAL_BURN);
                    i = 1;
                    if (effectinstance1 != null) {
                        i += effectinstance1.getAmplifier();
                        target.removeEffectNoUpdate((Holder)ModEffect.EFFECTABYSSAL_BURN);
                    } else {
                        --i;
                    }
                    i = Mth.clamp((int)i, (int)0, (int)3);
                    effectinstance = new MobEffectInstance((Holder)ModEffect.EFFECTABYSSAL_BURN, 160, i, false, true, true);
                    target.addEffect(effectinstance);
                }
            }
        }
        if (this.tickCount - 20 > this.getDuration()) {
            this.on = false;
        }
    }

    private void spawnUpdatedExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 1.0f;
            float yaw = (float)((double)(this.random.nextFloat() * 2.0f) * Math.PI);
            float motionY = this.random.nextFloat() * 0.08f;
            float motionX = 1.0f * Mth.cos((float)yaw);
            float motionZ = 1.0f * Mth.sin((float)yaw);
            this.level().addParticle((ParticleOptions)new LightningParticleOptions(102, 26, 204), this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    private void calculateUpdatedEndPos() {
        if (this.level().isClientSide()) {
            this.endPosX = this.getX() + 50.0 * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.getZ() + 50.0 * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.getY() + 50.0 * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.getX() + 50.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.getZ() + 50.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.getY() + 50.0 * Math.sin(this.getPitch());
        }
    }

    private void updateWithLivingEntity() {
        this.setYaw((float)((double)(this.caster.yHeadRot + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.getXRot()) * Math.PI / 180.0));
        double eyeOffset = 0.06;
        this.setPos(this.caster.getX(), this.caster.getY() + (double)this.caster.getEyeHeight() - eyeOffset, this.caster.getZ());
    }

    public AbyssLaserbeamHitResult updatedRaytraceEntities(Level world, Vec3 from, Vec3 to) {
        AbyssLaserbeamHitResult updatedResult = new AbyssLaserbeamHitResult();
        updatedResult.setBlockHit((HitResult)world.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (updatedResult.blockHit != null) {
            Vec3 hitVec = updatedResult.blockHit.getLocation();
            this.collidePosX = hitVec.x;
            this.collidePosY = hitVec.y;
            this.collidePosZ = hitVec.z;
            this.blockSide = updatedResult.blockHit.getDirection();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.getEntitiesOfClass(LivingEntity.class, new AABB(Math.min(this.getX(), this.collidePosX), Math.min(this.getY(), this.collidePosY), Math.min(this.getZ(), this.collidePosZ), Math.max(this.getX(), this.collidePosX), Math.max(this.getY(), this.collidePosY), Math.max(this.getZ(), this.collidePosZ)).inflate(2.0, 2.0, 2.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.getPickRadius() + 0.5f;
            AABB aabb = entity.getBoundingBox().inflate((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.clip(from, to);
            if (aabb.contains(from)) {
                updatedResult.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            updatedResult.addEntityHit(entity);
        }
        return updatedResult;
    }

    public static class AbyssLaserbeamHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

