/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects;

import com.gametechbc.traveloptics.api.utils.CurioUtils;
import com.gametechbc.traveloptics.entity.extended.ExtendedFlareBombEntity;
import com.gametechbc.traveloptics.entity.extended.ExtendedIgnisFireballEntity;
import com.gametechbc.traveloptics.init.TOEffects;
import com.gametechbc.traveloptics.init.TOEntities;
import com.gametechbc.traveloptics.init.TOItems;
import com.github.L_Ender.cataclysm.entity.projectile.Flare_Bomb_Entity;
import com.github.L_Ender.cataclysm.init.ModParticle;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.ShockwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MeteorStormEffect
extends MobEffect {
    private int ticksSinceLastSummon = 0;
    private double outerRadius = 25.0;

    public MeteorStormEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
    }

    public void setOuterRadius(double radius) {
        this.outerRadius = radius;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level;
        if (!entity.level().isClientSide && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++this.ticksSinceLastSummon;
            if (this.ticksSinceLastSummon >= 15) {
                if (CurioUtils.getWearingCurio(entity, (Item)TOItems.FIRESTORM_RING.get())) {
                    this.summonFlareBombs(serverLevel, entity);
                } else {
                    this.summonProjectiles(serverLevel, entity);
                }
                this.ticksSinceLastSummon = 0;
            }
        }
        super.applyEffectTick(entity, amplifier);
        return true;
    }

    private void summonProjectiles(ServerLevel serverLevel, LivingEntity target) {
        RandomSource random = target.getRandom();
        double innerRadius = 8.0;
        List nearbyEntities = serverLevel.getEntities((Entity)target, target.getBoundingBox().inflate(this.outerRadius), entity -> {
            LivingEntity targetEntity;
            return entity instanceof LivingEntity && !this.isTeammate(target, targetEntity = (LivingEntity)entity) && !this.isTamedCreature(target, targetEntity);
        });
        Collections.shuffle(nearbyEntities, new Random(random.nextLong()));
        int numEntitiesToTarget = Math.min(nearbyEntities.size(), 2);
        MobEffectInstance effect = target.getEffect(TOEffects.METEOR_STORM_EFFECT);
        int amplifier = effect != null ? effect.getAmplifier() : 0;
        for (int i = 0; i < 3; ++i) {
            Vec3 spawnPosition;
            if (i < numEntitiesToTarget) {
                Entity targetEntity = (Entity)nearbyEntities.get(i);
                Vec3 motion = targetEntity.getDeltaMovement();
                double predictionTime = 1.0;
                Vec3 predictedPosition = targetEntity.position().add(motion.scale(predictionTime));
                spawnPosition = new Vec3(predictedPosition.x, predictedPosition.y + 30.0, predictedPosition.z);
                MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)new ShockwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), -1.5f, true), (double)predictedPosition.x, (double)predictedPosition.y, (double)predictedPosition.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            } else {
                double angle = random.nextDouble() * Math.PI * 2.0;
                double distance = innerRadius + random.nextDouble() * (this.outerRadius - innerRadius);
                double xOffset = Math.cos(angle) * distance;
                double zOffset = Math.sin(angle) * distance;
                double yOffset = 30.0;
                spawnPosition = new Vec3(target.getX() + xOffset, target.getY() + yOffset, target.getZ() + zOffset);
            }
            int adjustedAmplifier = amplifier;
            if (CurioUtils.getWearingCurio(target, (Item)TOItems.AZURE_IGNITION_BRACELET.get())) {
                ++adjustedAmplifier;
            }
            ExtendedIgnisFireballEntity fireball = new ExtendedIgnisFireballEntity((EntityType<? extends ExtendedIgnisFireballEntity>)((EntityType)TOEntities.EXTENDED_IGNIS_FIREBALL.get()), (Level)serverLevel);
            fireball.setPos(spawnPosition);
            fireball.shoot(0.0, -1.0, 0.0, 2.5f, 0.0f);
            fireball.setSoul(target.getHealth() < target.getMaxHealth() * 0.5f || CurioUtils.getWearingCurio(target, (Item)TOItems.AZURE_IGNITION_BRACELET.get()));
            fireball.setCustomDamage(adjustedAmplifier);
            serverLevel.addFreshEntity((Entity)fireball);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)((ParticleOptions)ModParticle.TRAP_FLAME.get()), (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)0.0, (double)-1.0, (double)0.0, (double)0.0, (boolean)true);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.SUNBEAM, (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)false);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.SUNBEAM, (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)true);
        }
    }

    private void summonFlareBombs(ServerLevel serverLevel, LivingEntity entity) {
        MobEffectInstance effect = entity.getEffect(TOEffects.METEOR_STORM_EFFECT);
        int amplifier = effect != null ? effect.getAmplifier() : 0;
        RandomSource random = entity.getRandom();
        double innerRadius = 4.0;
        for (int i = 0; i < 3; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double distance = innerRadius + random.nextDouble() * (this.outerRadius - innerRadius);
            double xOffset = Math.cos(angle) * distance;
            double zOffset = Math.sin(angle) * distance;
            double yOffset = 30.0;
            Vec3 spawnPosition = new Vec3(entity.getX() + xOffset, entity.getY() + yOffset, entity.getZ() + zOffset);
            int adjustedAmplifier = amplifier;
            if (CurioUtils.getWearingCurio(entity, (Item)TOItems.AZURE_IGNITION_BRACELET.get())) {
                ++adjustedAmplifier;
            }
            ExtendedFlareBombEntity flareBomb = new ExtendedFlareBombEntity((EntityType<? extends Flare_Bomb_Entity>)((EntityType)TOEntities.EXTENDED_FLARE_BOMB.get()), (Level)serverLevel);
            flareBomb.setPos(spawnPosition);
            flareBomb.setDeltaMovement(0.0, -1.0, 0.0);
            flareBomb.setFlameJetDamage(adjustedAmplifier);
            flareBomb.setOwner((Entity)entity);
            serverLevel.addFreshEntity((Entity)flareBomb);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)((ParticleOptions)ModParticle.TRAP_FLAME.get()), (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)0.0, (double)-1.0, (double)0.0, (double)0.0, (boolean)true);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.SUNBEAM, (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)false);
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.SUNBEAM, (double)spawnPosition.x, (double)spawnPosition.y, (double)spawnPosition.z, (int)1, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (boolean)true);
        }
    }

    private boolean isTeammate(LivingEntity caster, LivingEntity target) {
        return caster.isAlliedTo((Entity)target);
    }

    private boolean isTamedCreature(LivingEntity caster, LivingEntity target) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamedAnimal = (TamableAnimal)target;
            return tamedAnimal.isTame() && tamedAnimal.getOwner() == caster;
        }
        return false;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

