/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects;

import com.gametechbc.traveloptics.init.TOEffects;
import com.gametechbc.traveloptics.util.TOTags;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AstralSenseTreasureEffect
extends MobEffect {
    private static final int TNT_RADIUS = 8;
    private static final int LOOT_RADIUS = 12;
    private static final int TRAP_RADIUS = 8;

    public AstralSenseTreasureEffect() {
        super(MobEffectCategory.BENEFICIAL, 16766720);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        Level level = player.level();
        this.detectPrimedTNT(player, level, 8);
        this.detectLootChest(player, level, 12);
        this.detectTraps(player, level, 8);
        this.isValuableBlockNearby(player, level, 12);
        return true;
    }

    private void detectLootChest(Player player, Level level, int radius) {
        BlockPos playerPos = player.blockPosition();
        BlockPos nearestChest = null;
        double nearestDistanceSqr = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-radius, -radius, -radius), (BlockPos)playerPos.offset(radius, radius, radius))) {
            double distanceSqr;
            ChestBlockEntity chestEntity;
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block instanceof ChestBlock)) continue;
            ChestBlock chest = (ChestBlock)block;
            block = level.getBlockEntity(pos);
            if (!(block instanceof ChestBlockEntity) || (chestEntity = (ChestBlockEntity)block).isEmpty() || !((distanceSqr = pos.distSqr((Vec3i)playerPos)) < nearestDistanceSqr)) continue;
            nearestDistanceSqr = distanceSqr;
            nearestChest = pos;
        }
        if (nearestChest != null) {
            int distance = (int)Math.sqrt(nearestDistanceSqr);
            this.sendMessage(player, (Component)Component.translatable((String)"spell.traveloptics.message.astral_sense.loot_chest", (Object[])new Object[]{distance}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private void detectTraps(Player player, Level level, int radius) {
        this.getNearbyBlocks(player.blockPosition(), radius).map(arg_0 -> ((Level)level).getBlockState(arg_0)).filter(state -> state.is(Blocks.TRIPWIRE) && (Boolean)state.getValue((Property)TripWireBlock.ATTACHED) != false).anyMatch(state -> this.sendMessage(player, (Component)Component.translatable((String)"spell.traveloptics.message.astral_sense.trap").withStyle(ChatFormatting.RED)));
    }

    private void detectPrimedTNT(Player player, Level level, int radius) {
        if (!level.getEntitiesOfClass(PrimedTnt.class, player.getBoundingBox().inflate((double)radius)).isEmpty()) {
            this.sendMessage(player, (Component)Component.translatable((String)"spell.traveloptics.message.astral_sense.tnt").withStyle(ChatFormatting.RED));
        }
    }

    private Stream<BlockPos> getNearbyBlocks(BlockPos center, int radius) {
        return BlockPos.betweenClosedStream((BlockPos)center.offset(-radius, -radius, -radius), (BlockPos)center.offset(radius, radius, radius));
    }

    private void isValuableBlockNearby(Player player, Level level, int radius) {
        BlockPos playerPos = player.blockPosition();
        BlockPos nearestBlock = null;
        double nearestDistanceSqr = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-radius, -radius, -radius), (BlockPos)playerPos.offset(radius, radius, radius))) {
            double distanceSqr;
            if (!level.getBlockState(pos).is(TOTags.EXTREMELY_VALUABLES) || !((distanceSqr = pos.distSqr((Vec3i)playerPos)) < nearestDistanceSqr)) continue;
            nearestDistanceSqr = distanceSqr;
            nearestBlock = pos;
        }
        if (nearestBlock != null) {
            int distance = (int)Math.sqrt(nearestDistanceSqr);
            this.sendMessage(player, (Component)Component.translatable((String)"spell.traveloptics.message.astral_sense.valuable_block", (Object[])new Object[]{distance}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private boolean sendMessage(Player player, Component message) {
        player.displayClientMessage(message, true);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 5 == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AstralSenseFogFunction
    implements FogRenderer.MobEffectFogFunction {
        public Holder<MobEffect> getMobEffect() {
            return TOEffects.ASTRAL_SENSE_TREASURE;
        }

        public void setupFog(FogRenderer.FogData fogData, LivingEntity entity, MobEffectInstance mobEffectInstance, float p_234184_, float p_234185_) {
            float f = 160.0f;
            if (fogData.mode == FogRenderer.FogMode.FOG_SKY) {
                fogData.start = 0.0f;
                fogData.end = f * 0.25f;
            } else {
                fogData.start = -f * 0.5f;
                fogData.end = f;
            }
        }
    }
}

