/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class SwitchManager {
    private static final String SWITCHES_TAG = "TOSwitchStates";

    public static boolean isEnabled(ItemStack stack, String switchKey) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag switches = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getCompound(SWITCHES_TAG);
            return switches.getBoolean(switchKey);
        }
        return false;
    }

    public static void setSwitch(ItemStack stack, String switchKey, boolean state) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            CompoundTag switches = tag.getCompound(SWITCHES_TAG);
            switches.putBoolean(switchKey, state);
            tag.put(SWITCHES_TAG, (Tag)switches);
        });
    }

    public static void toggleSwitch(ItemStack stack, String switchKey) {
        SwitchManager.setSwitch(stack, switchKey, !SwitchManager.isEnabled(stack, switchKey));
    }
}

