/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.particle.SphereParticleManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class DarknessManager {
    public static final int MAX_DARKNESS_POINTS = 300;
    private static final String DARKNESS_TAG = "TODarkness";

    public static int getDarkness(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            return ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getInt(DARKNESS_TAG);
        }
        return 0;
    }

    public static void setDarkness(ItemStack stack, int points) {
        int cappedPoints = Math.min(points, 300);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt(DARKNESS_TAG, cappedPoints));
    }

    public static void addDarkness(ItemStack stack, Player player, int amount) {
        int currentPoints = DarknessManager.getDarkness(stack);
        int newPoints = Math.min(currentPoints + amount, 300);
        DarknessManager.setDarkness(stack, newPoints);
        DarknessManager.playSoundOnThreshold(player, currentPoints, newPoints);
        DarknessManager.spawnParticlesOnThreshold(player, currentPoints, newPoints);
    }

    public static void displayActionBar(Player player, int points) {
        if (player instanceof ServerPlayer) {
            int percentage = (int)((double)points / 300.0 * 100.0);
            MutableComponent message = Component.literal((String)("\u26a1 Plasma Fuel: " + percentage + "%")).withStyle(style -> style.withColor(points >= 300 ? 15219515 : 16476957)).withStyle(ChatFormatting.BOLD);
            player.displayClientMessage((Component)message, true);
        }
    }

    private static void playSoundOnThreshold(Player player, int oldPoints, int newPoints) {
        if (player.level().isClientSide()) {
            return;
        }
        if (newPoints < 300 || oldPoints < 300) {
            // empty if block
        }
    }

    private static void spawnParticlesOnThreshold(Player player, int oldPoints, int newPoints) {
        if (newPoints >= 300 && oldPoints < 300) {
            SphereParticleManager.spawnParticles(player.level(), (LivingEntity)player, 25, (ParticleOptions)ParticleTypes.SMOKE, ParticleDirection.OUTWARD, 4.0);
        }
    }
}

