/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.immeng.data;

import blusunrize.immersiveengineering.api.IEProperties;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class ExtendedBlockStatesProvider
extends BlockStateProvider {
    public ExtendedBlockStatesProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "immeng", exFileHelper);
    }

    protected void createAllRotatedBlock(Supplier<? extends Block> block, ModelFile model) {
        this.createAllRotatedBlock(block, $ -> model, List.of());
    }

    protected void createAllRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, List<Property<?>> additionalProps) {
        this.createRotatedBlock(block, model, (Property<Direction>)IEProperties.FACING_ALL, additionalProps, 90, 0);
    }

    protected void createRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, Property<Direction> facing, List<Property<?>> additionalProps, int offsetRotX, int offsetRotY) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(block.get());
        ExtendedBlockStatesProvider.forEachState(stateBuilder.partialState(), additionalProps, state -> {
            ModelFile modelLoc = (ModelFile)model.apply((VariantBlockStateBuilder.PartialBlockstate)state);
            for (Direction d : facing.getPossibleValues()) {
                int y;
                int x;
                switch (d) {
                    case UP: {
                        x = 90;
                        y = 0;
                        break;
                    }
                    case DOWN: {
                        x = -90;
                        y = 0;
                        break;
                    }
                    default: {
                        y = this.getAngle(d, offsetRotY);
                        x = 0;
                    }
                }
                state.with(facing, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(modelLoc, x + offsetRotX, y, false)});
            }
        });
    }

    protected int getAngle(Direction dir, int offset) {
        return (int)((dir.toYRot() + (float)offset) % 360.0f);
    }

    public static <T extends Comparable<T>> void forEach(VariantBlockStateBuilder.PartialBlockstate base, Property<T> prop, List<Property<?>> remaining, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        for (Comparable value : prop.getPossibleValues()) {
            ExtendedBlockStatesProvider.forEachState(base, remaining, map -> {
                map = map.with(prop, value);
                out.accept((VariantBlockStateBuilder.PartialBlockstate)map);
            });
        }
    }

    public static void forEachState(VariantBlockStateBuilder.PartialBlockstate base, List<Property<?>> props, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        if (props.size() > 0) {
            List<Property<?>> remaining = props.subList(1, props.size());
            Property<?> main = props.get(0);
            ExtendedBlockStatesProvider.forEach(base, main, remaining, out);
        } else {
            out.accept(base);
        }
    }
}

