/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import dev.kir.cubeswithoutborders.client.util.FramebufferUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ResizableGameRenderer {
    private static final ResizableGameRenderer INSTANCE = new ResizableGameRenderer(Minecraft.getInstance());
    private final Minecraft client;
    private RenderTarget framebuffer;
    private RenderTarget clientFramebuffer;
    private int framebufferWidth;
    private int framebufferHeight;
    private int windowFramebufferWidth;
    private int windowFramebufferHeight;

    private ResizableGameRenderer(Minecraft client) {
        this.client = client;
        this.framebuffer = null;
        this.clientFramebuffer = null;
        this.framebufferWidth = -1;
        this.framebufferHeight = -1;
    }

    public static ResizableGameRenderer getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.framebufferWidth > 0 && this.framebufferHeight > 0;
    }

    public boolean isRendering() {
        return this.clientFramebuffer != null;
    }

    public void resize(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
        this.reload();
    }

    public void reload() {
        if (!this.isEnabled()) {
            return;
        }
        FramebufferUtil.resize(this.framebuffer, this.framebufferWidth, this.framebufferHeight);
        this.resizeWorldRendererFramebuffers();
    }

    public void disable() {
        this.framebufferWidth = -1;
        this.framebufferHeight = -1;
        Window window = this.client.getWindow();
        if (window != null && this.windowFramebufferWidth > 0 && this.windowFramebufferHeight > 0) {
            window.framebufferWidth = this.windowFramebufferWidth;
            window.framebufferHeight = this.windowFramebufferHeight;
        }
        this.windowFramebufferWidth = -1;
        this.windowFramebufferHeight = -1;
        if (this.clientFramebuffer != null) {
            this.client.mainRenderTarget = this.clientFramebuffer;
            this.client.getMainRenderTarget().bindWrite(true);
        }
        this.clientFramebuffer = null;
        if (this.framebuffer != null) {
            this.framebuffer.destroyBuffers();
            this.framebuffer = null;
        }
    }

    public void beginRender() {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        Window window = this.client.getWindow();
        if (!this.isEnabled() || window == null) {
            return;
        }
        if (this.framebuffer == null) {
            this.framebuffer = new MainTarget(width, height);
            this.framebuffer.resize(width, height, Minecraft.ON_OSX);
            this.resizeWorldRendererFramebuffers();
        }
        this.windowFramebufferWidth = window.framebufferWidth;
        this.windowFramebufferHeight = window.framebufferHeight;
        window.framebufferWidth = width;
        window.framebufferHeight = height;
        this.clientFramebuffer = this.client.getMainRenderTarget();
        this.client.mainRenderTarget = this.framebuffer;
        this.framebuffer.bindWrite(true);
    }

    public void endRender() {
        Window window = this.client.getWindow();
        if (!this.isEnabled() || window == null) {
            return;
        }
        if (this.framebuffer == null || this.clientFramebuffer == null) {
            return;
        }
        window.framebufferWidth = this.windowFramebufferWidth;
        window.framebufferHeight = this.windowFramebufferHeight;
        this.windowFramebufferWidth = -1;
        this.windowFramebufferHeight = -1;
        this.client.mainRenderTarget = this.clientFramebuffer;
        this.client.getMainRenderTarget().bindWrite(true);
        this.framebuffer.blitToScreen(window.getWidth(), window.getHeight());
        this.clientFramebuffer = null;
    }

    private void resizeWorldRendererFramebuffers() {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        Window window = this.client.getWindow();
        LevelRenderer worldRenderer = this.client.levelRenderer;
        if (window == null) {
            return;
        }
        FramebufferUtil.resize(worldRenderer.getCloudsTarget(), width, height);
        FramebufferUtil.resize(worldRenderer.getItemEntityTarget(), width, height);
        FramebufferUtil.resize(worldRenderer.entityTarget(), width, height);
        FramebufferUtil.resize(worldRenderer.getParticlesTarget(), width, height);
        FramebufferUtil.resize(worldRenderer.getTranslucentTarget(), width, height);
        FramebufferUtil.resize(worldRenderer.getWeatherTarget(), width, height);
    }
}

