/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.silencemobs_common_neoforge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.silencemobs_common_neoforge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CommandSt {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"st").requires(iCommandSender -> iCommandSender.getEntity() instanceof Player && (!ConfigHandler.onlyAllowCommandWhenCheatsEnabled || iCommandSender.hasPermission(2)))).executes(command -> {
            CommandSt.processSilencestick((CommandContext<CommandSourceStack>)command);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"silencestick").requires(iCommandSender -> iCommandSender.getEntity() instanceof Player && (!ConfigHandler.onlyAllowCommandWhenCheatsEnabled || iCommandSender.hasPermission(2)))).executes(command -> {
            CommandSt.processSilencestick((CommandContext<CommandSourceStack>)command);
            return 1;
        }));
    }

    public static void processSilencestick(CommandContext<CommandSourceStack> command) {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        ServerPlayer player = source.getPlayer();
        if (ConfigHandler.mustHoldStick) {
            ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!held.getItem().equals(Items.STICK)) {
                MessageFunctions.sendMessage((Player)player, (String)"You must hold a stick in your main hand to transform it into a silence-stick.", (ChatFormatting)ChatFormatting.DARK_RED);
                return;
            }
            player.getMainHandItem().shrink(1);
        }
        ItemStack silencestick = new ItemStack((ItemLike)Items.STICK, 1);
        silencestick.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + "The Silence Stick")));
        player.addItem(silencestick);
        MessageFunctions.sendMessage((Player)player, (String)"You have been given The Silence Stick! Handle with care.", (ChatFormatting)ChatFormatting.DARK_GREEN);
    }
}

