/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.eternalnether.init.ModBlocks;
import fuzs.eternalnether.world.level.block.entity.NetheriteBellBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NetheriteBellBlock
extends BaseEntityBlock {
    public static final MapCodec<NetheriteBellBlock> CODEC = NetheriteBellBlock.simpleCodec(NetheriteBellBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.BELL_ATTACHMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape NORTH_SOUTH_FLOOR_SHAPE = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape EAST_WEST_FLOOR_SHAPE = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape BELL_TOP_SHAPE = Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape BELL_SHAPE = Shapes.or((VoxelShape)BELL_BOTTOM_SHAPE, (VoxelShape)BELL_TOP_SHAPE);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)0.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_WEST = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)0.0, (double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_EAST = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)3.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_NORTH = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)13.0));
    private static final VoxelShape TO_SOUTH = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)3.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.or((VoxelShape)BELL_SHAPE, (VoxelShape)Block.box((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));

    public NetheriteBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(ATTACHMENT, (Comparable)BellAttachType.FLOOR)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends NetheriteBellBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ATTACHMENT, POWERED});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean bl = level.hasNeighborSignal(pos);
        if (bl != (Boolean)state.getValue((Property)POWERED)) {
            if (bl) {
                this.attemptToRing(level, pos, null);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 3);
        }
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity = projectile.getOwner();
        Player player = entity instanceof Player ? (Player)entity : null;
        this.onHit(level, state, hit, player, true);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.onHit(level, state, hitResult, player, true) ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.PASS;
    }

    public boolean onHit(Level level, BlockState state, BlockHitResult result, @Nullable Player player, boolean canRingBell) {
        boolean bl;
        Direction direction = result.getDirection();
        BlockPos blockPos = result.getBlockPos();
        boolean bl2 = bl = !canRingBell || this.isProperHit(state, direction, result.getLocation().y - (double)blockPos.getY());
        if (bl) {
            boolean bl22 = this.attemptToRing((Entity)player, level, blockPos, direction);
            if (bl22 && player != null) {
                player.awardStat(Stats.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(BlockState pos, Direction direction, double distanceY) {
        if (direction.getAxis() != Direction.Axis.Y && !(distanceY > (double)0.8124f)) {
            Direction direction2 = (Direction)pos.getValue((Property)FACING);
            BellAttachType bellAttachType = (BellAttachType)pos.getValue(ATTACHMENT);
            return switch (bellAttachType) {
                case BellAttachType.FLOOR -> {
                    if (direction2.getAxis() == direction.getAxis()) {
                        yield true;
                    }
                    yield false;
                }
                case BellAttachType.SINGLE_WALL, BellAttachType.DOUBLE_WALL -> {
                    if (direction2.getAxis() != direction.getAxis()) {
                        yield true;
                    }
                    yield false;
                }
                case BellAttachType.CEILING -> true;
                default -> false;
            };
        }
        return false;
    }

    public boolean attemptToRing(Level level, BlockPos pos, @Nullable Direction direction) {
        return this.attemptToRing(null, level, pos, direction);
    }

    public boolean attemptToRing(@Nullable Entity entity, Level level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!level.isClientSide && blockEntity instanceof NetheriteBellBlockEntity) {
            NetheriteBellBlockEntity bellBlockEntity = (NetheriteBellBlockEntity)blockEntity;
            if (direction == null) {
                direction = (Direction)level.getBlockState(pos).getValue((Property)FACING);
            }
            bellBlockEntity.onHit(direction);
            level.playSound(null, pos, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 4.5f, 0.5f);
            level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BellAttachType bellAttachType = (BellAttachType)state.getValue(ATTACHMENT);
        if (bellAttachType == BellAttachType.FLOOR) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_FLOOR_SHAPE : NORTH_SOUTH_FLOOR_SHAPE;
        }
        if (bellAttachType == BellAttachType.CEILING) {
            return CEILING_SHAPE;
        }
        if (bellAttachType == BellAttachType.DOUBLE_WALL) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN;
        }
        if (direction == Direction.NORTH) {
            return TO_NORTH;
        }
        if (direction == Direction.SOUTH) {
            return TO_SOUTH;
        }
        return direction == Direction.EAST ? TO_EAST : TO_WEST;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        Direction.Axis axis = direction.getAxis();
        if (axis == Direction.Axis.Y) {
            BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
            if (blockState.canSurvive((LevelReader)context.getLevel(), blockPos)) {
                return blockState;
            }
        } else {
            boolean bl = axis == Direction.Axis.X && level.getBlockState(blockPos.west()).isFaceSturdy((BlockGetter)level, blockPos.west(), Direction.EAST) && level.getBlockState(blockPos.east()).isFaceSturdy((BlockGetter)level, blockPos.east(), Direction.WEST) || axis == Direction.Axis.Z && level.getBlockState(blockPos.north()).isFaceSturdy((BlockGetter)level, blockPos.north(), Direction.SOUTH) && level.getBlockState(blockPos.south()).isFaceSturdy((BlockGetter)level, blockPos.south(), Direction.NORTH);
            BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue(ATTACHMENT, (Comparable)(bl ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockState.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
                return blockState;
            }
            boolean bl2 = level.getBlockState(blockPos.below()).isFaceSturdy((BlockGetter)level, blockPos.below(), Direction.UP);
            if ((blockState = (BlockState)blockState.setValue(ATTACHMENT, (Comparable)(bl2 ? BellAttachType.FLOOR : BellAttachType.CEILING))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
                return blockState;
            }
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BellAttachType bellAttachType = (BellAttachType)state.getValue(ATTACHMENT);
        Direction direction2 = NetheriteBellBlock.getConnectedDirection(state).getOpposite();
        if (direction2 == direction && !state.canSurvive((LevelReader)level, currentPos) && bellAttachType != BellAttachType.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction.getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis()) {
            if (bellAttachType == BellAttachType.DOUBLE_WALL && !neighborState.isFaceSturdy((BlockGetter)level, neighborPos, direction)) {
                return (BlockState)((BlockState)state.setValue(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            }
            if (bellAttachType == BellAttachType.SINGLE_WALL && direction2.getOpposite() == direction && neighborState.isFaceSturdy((BlockGetter)level, neighborPos, (Direction)state.getValue((Property)FACING))) {
                return (BlockState)state.setValue(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = NetheriteBellBlock.getConnectedDirection(state).getOpposite();
        return direction == Direction.UP ? Block.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)level, (BlockPos)pos, (Direction)direction);
    }

    private static Direction getConnectedDirection(BlockState state) {
        return switch ((BellAttachType)state.getValue(ATTACHMENT)) {
            case BellAttachType.FLOOR -> Direction.UP;
            case BellAttachType.CEILING -> Direction.DOWN;
            default -> ((Direction)state.getValue((Property)FACING)).getOpposite();
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new NetheriteBellBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return NetheriteBellBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.NETHERITE_BELL_BLOCK_ENTITY_TYPE.value()), (BlockEntityTicker)(level.isClientSide ? NetheriteBellBlockEntity::clientTick : NetheriteBellBlockEntity::serverTick));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

