/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.data;

import de.melanx.extradisks.data.BlockModels;
import de.melanx.extradisks.data.BlockStates;
import de.melanx.extradisks.data.ExtraAdvancementProvider;
import de.melanx.extradisks.data.ExtraLootTables;
import de.melanx.extradisks.data.ModItemModels;
import de.melanx.extradisks.data.ModTags;
import de.melanx.extradisks.data.Recipes;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="extradisks", bus=EventBusSubscriber.Bus.MOD)
public class DataCreator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ModTags.BlockTags blockTagsProvider = new ModTags.BlockTags(output, lookupProvider, helper);
        boolean server = event.includeServer();
        generator.addProvider(server, (DataProvider)blockTagsProvider);
        generator.addProvider(server, (DataProvider)new ModTags.ItemTags(output, lookupProvider, blockTagsProvider.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new Recipes(output, lookupProvider));
        generator.addProvider(server, (DataProvider)new ExtraAdvancementProvider(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ExtraLootTables::new, LootContextParamSets.BLOCK)), lookupProvider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new ModItemModels(output, helper));
        generator.addProvider(client, (DataProvider)new BlockStates(output, helper));
        generator.addProvider(client, (DataProvider)new BlockModels(output, helper));
    }
}

