/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public class NetworkStatistics {
    public static final int CHANGE_COUNT = 6;
    private final FluxNetwork network;
    private int timer;
    public int fluxPlugCount;
    public int fluxPointCount;
    public int fluxControllerCount;
    public int fluxStorageCount;
    public long energyInput;
    public long energyOutput;
    public final LongList energyChange = new LongArrayList(6);
    public long totalBuffer;
    public long totalEnergy;
    private long energyChange5;
    private long energyInput4;
    private long energyOutput4;
    public int averageTickMicro;
    private long runningTotalNano;
    private long startNanoTime;

    public NetworkStatistics(FluxNetwork network) {
        this.network = network;
        this.energyChange.size(6);
    }

    public void startProfiling() {
        this.startNanoTime = System.nanoTime();
    }

    public void stopProfiling() {
        if (this.timer == 0) {
            this.weakestTick();
        }
        if (this.timer % 5 == 0) {
            this.weakTick();
        }
        if (this.timer % 20 == 0) {
            this.weakerTick();
        }
        this.runningTotalNano += System.nanoTime() - this.startNanoTime;
        ++this.timer;
        this.timer %= 100;
    }

    private void weakTick() {
        List<TileFluxDevice> plugs = this.network.getLogicalDevices(1);
        plugs.forEach(p -> {
            if (!p.getDeviceType().isStorage()) {
                this.energyInput4 += p.getTransferChange();
            }
        });
        List<TileFluxDevice> points = this.network.getLogicalDevices(2);
        points.forEach(p -> {
            if (!p.getDeviceType().isStorage()) {
                this.energyOutput4 -= p.getTransferChange();
            }
        });
    }

    private void weakerTick() {
        this.totalBuffer = 0L;
        this.totalEnergy = 0L;
        List<TileFluxDevice> devices = this.network.getLogicalDevices(0);
        devices.forEach(p -> {
            if (!p.getDeviceType().isStorage()) {
                this.totalBuffer += p.getTransferBuffer();
            }
        });
        List<TileFluxDevice> storages = this.network.getLogicalDevices(3);
        storages.forEach(p -> this.totalEnergy += p.getTransferBuffer());
        this.fluxControllerCount = this.network.getLogicalDevices(4).size();
        this.fluxStorageCount = storages.size();
        this.fluxPlugCount = this.network.getLogicalDevices(1).size() - this.fluxStorageCount;
        this.fluxPointCount = this.network.getLogicalDevices(2).size() - this.fluxStorageCount - this.fluxControllerCount;
        this.energyInput = this.energyInput4 / 4L;
        this.energyOutput = this.energyOutput4 / 4L;
        this.energyInput4 = 0L;
        this.energyOutput4 = 0L;
        this.energyChange5 += Math.max(this.energyInput, this.energyOutput);
        this.averageTickMicro = (int)Math.min(this.runningTotalNano / 20000L, Integer.MAX_VALUE);
        this.runningTotalNano = 0L;
    }

    private void weakestTick() {
        for (int i = 1; i < 6; ++i) {
            this.energyChange.set(i - 1, this.energyChange.getLong(i));
        }
        this.energyChange.set(5, this.energyChange5 / 5L);
        this.energyChange5 = 0L;
    }

    public int getConnectionCount() {
        return this.fluxPlugCount + this.fluxPointCount + this.fluxStorageCount + this.fluxControllerCount;
    }

    public void writeNBT(CompoundTag tag) {
        tag.putInt("1", this.fluxPlugCount);
        tag.putInt("2", this.fluxPointCount);
        tag.putInt("3", this.fluxControllerCount);
        tag.putInt("4", this.fluxStorageCount);
        tag.putLong("5", this.energyInput);
        tag.putLong("6", this.energyOutput);
        tag.putLong("7", this.totalBuffer);
        tag.putLong("8", this.totalEnergy);
        tag.putInt("9", this.averageTickMicro);
        tag.putLongArray("a", (List)this.energyChange);
    }

    public void readNBT(CompoundTag tag) {
        this.fluxPlugCount = tag.getInt("1");
        this.fluxPointCount = tag.getInt("2");
        this.fluxControllerCount = tag.getInt("3");
        this.fluxStorageCount = tag.getInt("4");
        this.energyInput = tag.getLong("5");
        this.energyOutput = tag.getLong("6");
        this.totalBuffer = tag.getLong("7");
        this.totalEnergy = tag.getLong("8");
        this.averageTickMicro = tag.getInt("9");
        long[] a = tag.getLongArray("a");
        for (int i = 0; i < a.length; ++i) {
            this.energyChange.set(i, a[i]);
        }
    }
}

