/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupHost;
import sonar.fluxnetworks.client.mui.MUIIntegration;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.ClientMessages;

public abstract class GuiFluxCore
extends GuiPopupHost {
    protected final List<GuiButtonCore> mButtons = new ArrayList<GuiButtonCore>();
    public final Player mPlayer;
    private FluxNetwork mNetwork;

    public GuiFluxCore(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mPlayer = player;
        this.mNetwork = ClientCache.getNetwork(menu.mProvider.getNetworkID());
        menu.mOnResultListener = this::onResponse;
    }

    private void onResponse(FluxMenu menu, int key, int code) {
        FluxTranslate t = FluxTranslate.fromResponseCode(code);
        if (t != null) {
            if (GuiFluxCore.useModernDesign()) {
                MUIIntegration.showToastError(t);
            } else {
                this.getMinecraft().getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.getMinecraft(), (SystemToast.SystemToastId)SystemToast.SystemToastId.WORLD_ACCESS_FAILURE, (Component)Component.literal((String)"Flux Networks"), (Component)t.getComponent()));
            }
        }
        this.onResponseAction(key, code);
    }

    public int getToken() {
        return ((FluxMenu)this.menu).containerId;
    }

    @Nonnull
    public FluxNetwork getNetwork() {
        return this.mNetwork;
    }

    @Nonnull
    public AccessLevel getAccessLevel() {
        return this.mNetwork.getPlayerAccess(this.mPlayer);
    }

    @Override
    public void init() {
        super.init();
        this.mButtons.clear();
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        for (GuiButtonCore button : this.mButtons) {
            button.drawButton(gr, mouseX, mouseY, deltaTicks);
        }
    }

    @Override
    protected void drawBackgroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (GuiFluxCore.useModernDesign()) {
            MUIIntegration.drawBackgroundAndFrame(gr, this.width, this.height, this.mNetwork.getNetworkColor(), 1.0f);
        } else {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
            this.blitBackgroundOrFrame(gr);
            int color = this.mNetwork.getNetworkColor();
            RenderSystem.setShaderColor((float)FluxUtils.getRed(color), (float)FluxUtils.getGreen(color), (float)FluxUtils.getBlue(color), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FRAME);
            this.blitBackgroundOrFrame(gr);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (GuiButtonCore button : this.mButtons) {
            if (!button.mClickable || !button.isMouseHovered(mouseX, mouseY)) continue;
            this.onButtonClicked(button, (float)mouseX, (float)mouseY, mouseButton);
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        this.mNetwork = ClientCache.getNetwork(((FluxMenu)this.menu).mProvider.getNetworkID());
    }

    public void onClose() {
        super.onClose();
    }

    protected void renderNetwork(GuiGraphics gr, String name, int color, int y) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)FluxUtils.getRed(color), (float)FluxUtils.getGreen(color), (float)FluxUtils.getBlue(color), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON);
        int x = this.leftPos + 20;
        GuiFluxCore.blitF(gr, x, y, 135.0f, 12.0f, 0.0f, 320.0f, 270.0f, 24.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gr.drawString(this.font, name, x + 4, y + 2, 0xFFFFFF);
    }

    protected void renderTransfer(GuiGraphics gr, IFluxDevice device, int x, int y) {
        RenderSystem.enableBlend();
        gr.drawString(this.font, FluxUtils.getTransferInfo(device, EnergyType.FE), x, y, 0xFFFFFF);
        Object text = device.getDeviceType().isStorage() ? FluxTranslate.ENERGY.get() : FluxTranslate.BUFFER.get();
        text = (String)text + ": " + String.valueOf(ChatFormatting.BLUE) + EnergyType.FE.getStorage(device.getTransferBuffer());
        gr.drawString(this.font, (String)text, x, y + 10, 0xFFFFFF);
        this.renderItemStack(gr, device.getDisplayStack(), x - 20, y + 1);
    }

    protected void renderItemStack(GuiGraphics gr, ItemStack stack, int x, int y) {
        gr.pose().pushPose();
        gr.pose().translate(0.0f, 0.0f, 50.0f);
        gr.renderItem(stack, x, y);
        gr.renderItemDecorations(this.font, stack, x, y);
        gr.pose().popPose();
    }

    public void setConnectedNetwork(FluxNetwork network, String password) {
        if (((FluxMenu)this.menu).mProvider instanceof TileFluxDevice) {
            ClientMessages.tileNetwork(this.getToken(), (TileFluxDevice)((FluxMenu)this.menu).mProvider, network, password);
        } else if (((FluxMenu)this.menu).mProvider instanceof ItemAdminConfigurator.Provider) {
            ClientCache.sAdminViewingNetwork = network.getNetworkID();
        }
    }

    protected void onResponseAction(int key, int code) {
    }
}

