/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.button.SwitchButton;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiFluxAdminHome
extends GuiTabCore {
    public SwitchButton mDetailedNetworkView;
    public SwitchButton mSuperAdmin;
    public SimpleButton mCleanupCache;

    public GuiFluxAdminHome(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_HOME;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        int color = this.getNetwork().getNetworkColor();
        this.renderNetwork(gr, this.getNetwork().getNetworkName(), color, this.topPos + 8);
        gr.drawString(this.font, AccessLevel.SUPER_ADMIN.getFormattedName(), this.leftPos + 20, this.topPos + 30, color);
        gr.drawString(this.font, FluxTranslate.DETAILED_VIEW.get(), this.leftPos + 20, this.topPos + 42, color);
    }

    @Override
    public void init() {
        super.init();
        boolean superAdmin = ClientCache.sSuperAdmin;
        this.mSuperAdmin = new SwitchButton(this, this.leftPos + 140, this.topPos + 30, superAdmin);
        this.mButtons.add(this.mSuperAdmin);
        this.mDetailedNetworkView = new SwitchButton(this, this.leftPos + 140, this.topPos + 42, ClientCache.sDetailedNetworkView);
        this.mDetailedNetworkView.setClickable(superAdmin);
        this.mButtons.add(this.mDetailedNetworkView);
        this.mCleanupCache = new SimpleButton(this, this.leftPos + this.imageWidth / 2 - 50, this.topPos + 56, 100, 12, "Cleanup Client Cache");
        this.mButtons.add(this.mCleanupCache);
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button == this.mSuperAdmin) {
                ClientMessages.superAdmin(this.getToken(), !this.mSuperAdmin.isChecked());
            } else if (button == this.mDetailedNetworkView) {
                this.mDetailedNetworkView.toggle();
                ClientCache.sDetailedNetworkView = this.mDetailedNetworkView.isChecked();
            } else if (button == this.mCleanupCache) {
                ClientCache.cleanup();
            }
        }
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        boolean superAdmin = ClientCache.sSuperAdmin;
        this.mSuperAdmin.setChecked(superAdmin);
        this.mDetailedNetworkView.setClickable(superAdmin);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && mouseX >= (double)(this.leftPos + 20) && mouseX < (double)(this.leftPos + 155) && mouseY >= (double)(this.topPos + 8) && mouseY < (double)(this.topPos + 20)) {
            this.switchTab(EnumNavigationTab.TAB_SELECTION, false);
            return true;
        }
        return false;
    }
}

