/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.allthewizardgear.events;

import io.redspace.allthewizardgear.ServerConfig;
import io.redspace.allthewizardgear.item.WizardArmorItem;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        WizardArmorItem armorItem;
        Item item = event.getEntity().getItemBySlot(EquipmentSlot.FEET).getItem();
        if (item instanceof WizardArmorItem && ((Boolean)(armorItem = (WizardArmorItem)item).getConfig().bootsPreventFallDamage().get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingIncomingDamageEvent event) {
        if (!event.getEntity().getCommandSenderWorld().isClientSide) {
            DamageSources damageSources = event.getEntity().damageSources();
            ItemStack helmet = event.getEntity().getItemBySlot(EquipmentSlot.HEAD);
            ItemStack chestplate = event.getEntity().getItemBySlot(EquipmentSlot.CHEST);
            ItemStack leggings = event.getEntity().getItemBySlot(EquipmentSlot.LEGS);
            if (event.getSource() == damageSources.flyIntoWall() && ServerEvents.checkItem(helmet, ServerConfig.ArmorSetConfig::helmetPreventsElytraDamage)) {
                event.setCanceled(true);
            } else if (event.getSource() == damageSources.drown() && ServerEvents.checkItem(helmet, ServerConfig.ArmorSetConfig::helmetPreventsDrowning)) {
                event.getEntity().setAirSupply(event.getEntity().getMaxAirSupply());
                event.setCanceled(true);
            } else if (event.getSource().is(DamageTypeTags.IS_FIRE) && ServerEvents.checkItem(chestplate, ServerConfig.ArmorSetConfig::chestplatePreventsFire)) {
                event.getEntity().clearFire();
                event.setCanceled(true);
            } else if (event.getSource() == damageSources.dragonBreath() && ServerEvents.checkItem(chestplate, ServerConfig.ArmorSetConfig::chestplatePreventsDragonBreath)) {
                event.setCanceled(true);
            } else if (event.getSource() == damageSources.wither() && ServerEvents.checkItem(leggings, ServerConfig.ArmorSetConfig::leggingsPreventWither)) {
                event.getEntity().removeEffect(MobEffects.WITHER);
                event.setCanceled(true);
            } else if (ServerEvents.checkItem(leggings, ServerConfig.ArmorSetConfig::leggingsPreventLevitation)) {
                event.getEntity().removeEffect(MobEffects.LEVITATION);
            }
        }
    }

    private static boolean checkItem(ItemStack stack, Function<ServerConfig.ArmorSetConfig, Supplier<? extends Boolean>> run) {
        WizardArmorItem armorItem;
        Item item = stack.getItem();
        return item instanceof WizardArmorItem && run.apply((armorItem = (WizardArmorItem)item).getConfig()).get() != false;
    }
}

