/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.allthewizardgear;

import io.redspace.allthewizardgear.item.WizardArmorItem;
import io.redspace.allthewizardgear.registry.ItemRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="allthewizardgear", bus=EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    static ModConfigSpec SPEC;
    public static ArmorSetConfig ALLTHEMODIUM_CONFIG;
    public static ArmorSetConfig VIBRANIUM_CONFIG;
    public static ArmorSetConfig UNOBTAINIUM_CONFIG;

    private static ArmorSetConfig defineConfig(ModConfigSpec.Builder builder, String name, List<Integer> defenseValues, int toughness, double knockbackResistance, int maxMana, double spellPower, double manaRegen, boolean helmetPreventsDrowning, boolean helmetPreventsElytraDamage, boolean chestplatePreventsFire, boolean chestplatePreventsDragonBreath, boolean leggingsPreventWither, boolean leggingsPreventLevitation, boolean bootsPreventFallDamage, boolean makesPiglinsNeutral) {
        builder.push(name);
        String localizedName = name.substring(0, 1).toUpperCase() + name.substring(1) + "'s ";
        ArmorSetConfig config = new ArmorSetConfig(name, (ModConfigSpec.ConfigValue<List<? extends Integer>>)builder.worldRestart().comment(localizedName + "Armor Values, in the form of [boots, leggings, chestplate, helmet]. Default: " + String.valueOf(defenseValues)).defineList("armorValues", () -> defenseValues, x -> true), (ModConfigSpec.ConfigValue<? extends Integer>)builder.worldRestart().comment(localizedName + "Armor Toughness. Default: " + toughness).define("toughness", (Object)toughness), (ModConfigSpec.ConfigValue<? extends Double>)builder.worldRestart().comment(localizedName + "Knockback Resistance. Default: " + knockbackResistance).define("knockbackResistance", (Object)knockbackResistance), (ModConfigSpec.ConfigValue<? extends Integer>)builder.worldRestart().comment(localizedName + "Max Mana. Default: " + maxMana).define("maxMana", (Object)maxMana), (ModConfigSpec.ConfigValue<? extends Double>)builder.worldRestart().comment(localizedName + String.format("Spell Power. Default: %s (+%s%%)", spellPower, (int)(spellPower * 100.0))).define("spellPower", (Object)spellPower), (ModConfigSpec.ConfigValue<? extends Double>)builder.worldRestart().comment(localizedName + String.format("Mana Regen. Default: %s", manaRegen)).define("manaRegen", (Object)manaRegen), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Helmet Prevents Drowning. Default: %s", helmetPreventsDrowning)).define("helmetPreventsDrowning", helmetPreventsDrowning), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Helmet Prevents Elytra Damage. Default: %s", helmetPreventsElytraDamage)).define("helmetPreventsElytraDamage", helmetPreventsElytraDamage), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Chestplate Prevents Fire Damage. Default: %s", chestplatePreventsFire)).define("chestplatePreventsFire", chestplatePreventsFire), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Chestplate Prevents Dragon Breath. Default: %s", chestplatePreventsDragonBreath)).define("chestplatePreventsDragonBreath", chestplatePreventsDragonBreath), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Leggings Prevent Wither. Default: %s", leggingsPreventWither)).define("leggingsPreventWither", leggingsPreventWither), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Leggings Prevent Levitation. Default: %s", leggingsPreventLevitation)).define("leggingsPreventLevitation", leggingsPreventLevitation), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Boots Prevent Fall Damage. Default: %s", bootsPreventFallDamage)).define("bootsPreventFallDamage", bootsPreventFallDamage), (ModConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Armor makes Piglins Neutral (like gold armor). Default: %s", makesPiglinsNeutral)).define("makesPiglinsNeutral", makesPiglinsNeutral));
        builder.pop();
        return config;
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (Holder holder : ItemRegistry.items()) {
            Object object = holder.value();
            if (!(object instanceof WizardArmorItem)) continue;
            WizardArmorItem armorItem = (WizardArmorItem)((Object)object);
            armorItem.reload();
        }
    }

    static {
        BUILDER.push("ArmorConfig");
        BUILDER.comment("Changing armor values requires world restart");
        ALLTHEMODIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "allthemodium", List.of(Integer.valueOf(4), Integer.valueOf(7), Integer.valueOf(9), Integer.valueOf(4)), 4, 0.0, 200, 0.2, 0.05, true, true, true, false, false, false, true, true);
        VIBRANIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "vibranium", List.of(Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(11), Integer.valueOf(6)), 5, 0.0, 325, 0.3, 0.1, true, true, true, false, true, false, true, true);
        UNOBTAINIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "unobtainium", List.of(Integer.valueOf(8), Integer.valueOf(11), Integer.valueOf(13), Integer.valueOf(8)), 6, 0.0, 450, 0.4, 0.15, true, true, true, true, true, true, true, true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public record ArmorSetConfig(String name, ModConfigSpec.ConfigValue<List<? extends Integer>> defenseValues, ModConfigSpec.ConfigValue<? extends Integer> toughness, ModConfigSpec.ConfigValue<? extends Double> knockbackResistance, ModConfigSpec.ConfigValue<? extends Integer> maxMana, ModConfigSpec.ConfigValue<? extends Double> spellPower, ModConfigSpec.ConfigValue<? extends Double> manaRegen, ModConfigSpec.ConfigValue<? extends Boolean> helmetPreventsDrowning, ModConfigSpec.ConfigValue<? extends Boolean> helmetPreventsElytraDamage, ModConfigSpec.ConfigValue<? extends Boolean> chestplatePreventsFire, ModConfigSpec.ConfigValue<? extends Boolean> chestplatePreventsDragonBreath, ModConfigSpec.ConfigValue<? extends Boolean> leggingsPreventWither, ModConfigSpec.ConfigValue<? extends Boolean> leggingsPreventLevitation, ModConfigSpec.ConfigValue<? extends Boolean> bootsPreventFallDamage, ModConfigSpec.ConfigValue<? extends Boolean> makesPiglinsNeutral) {
        public double getDefenseFor(EquipmentSlot slot) {
            if (((List)this.defenseValues.get()).size() != 4) {
                return ((Integer)((List)this.defenseValues.getDefault()).get(slot.getIndex())).intValue();
            }
            return ((Integer)((List)this.defenseValues.get()).get(slot.getIndex())).intValue();
        }
    }
}

