/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.ManualItemHandler;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.PotionUtil;
import cy.jdkdigital.generatorgalore.util.collection.SetMultiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GeneratorUtil {
    public static ResourceLocation EMPTY_TAG = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"empty");
    public static String FUEL_SOLID = "SOLID";
    public static String FUEL_FLUID = "FLUID";
    public static String FUEL_FOOD = "FOOD";
    public static String FUEL_ENCHANTMENT = "ENCHANTMENT";
    public static final Path LOCK_FILE = GeneratorUtil.createCustomPath("");
    public static final Path GENERATORS = GeneratorUtil.createCustomPath("generators");

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "generatorgalore", pathName);
        GeneratorUtil.createDirectory(customPath, pathName);
        return customPath;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            GeneratorGalore.LOGGER.error("failed to create \"" + dirName + "\" directory");
        }
    }

    public static void replaceGenerator(Level level, BlockPos pos, GeneratorObject generator) {
        BlockState existingGenerator = level.getBlockState(pos);
        BlockState newGenerator = (BlockState)((BlockState)generator.getBlockSupplier().get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)existingGenerator.getValue((Property)HorizontalDirectionalBlock.FACING)))).setValue((Property)BlockStateProperties.LIT, (Comparable)((Boolean)existingGenerator.getValue((Property)BlockStateProperties.LIT)));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            CompoundTag tag = generatorBlockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            ManualItemHandler manualItemHandler = generatorBlockEntity.inventoryHandler;
            if (manualItemHandler instanceof ItemStackHandler) {
                ManualItemHandler itemHandler = manualItemHandler;
                itemHandler.setStackInSlot(0, ItemStack.EMPTY);
                itemHandler.setStackInSlot(1, ItemStack.EMPTY);
            }
            level.setBlockAndUpdate(pos, newGenerator);
            level.getBlockEntity(pos).loadCustomOnly(tag, (HolderLookup.Provider)level.registryAccess());
        }
    }

    public static Pair<Float, Integer> calculateFoodGenerationRate(GeneratorObject generator, ItemStack stack) {
        FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, null);
        if (foodProperties != null) {
            int value = foodProperties.nutrition();
            float saturation = foodProperties.saturation();
            double totalRF = (float)value * saturation * 8000.0f;
            return Pair.of((Object)Float.valueOf((float)((double)value * generator.getOriginalGenerationRate())), (Object)((int)(totalRF / generator.getGenerationRate())));
        }
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)generator.getConsumptionRate()));
    }

    public static Pair<Float, Integer> calculateEnchantmentGenerationRate(GeneratorObject generator, ItemStack stack) {
        if (stack.isEnchanted() || stack.getItem() instanceof EnchantedBookItem) {
            double totalRF = 0.0;
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                float level = entry.getValue().intValue();
                float max = enchantment.getMaxLevel();
                float min = enchantment.getMinCost(entry.getValue().intValue());
                float weight = enchantment.getWeight();
                totalRF += Math.abs(Math.sqrt(Math.min((double)level + 1.0, (double)max) / (double)max) * Math.pow(max, 2.0) * (double)(level + 1.0f) * ((double)min / Math.sqrt(weight))) * 400.0;
            }
            return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)(totalRF / generator.getGenerationRate())));
        }
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)generator.getConsumptionRate()));
    }

    public static Pair<Float, Integer> calculatePotionGenerationRate(Level level, GeneratorObject generator, ItemStack stack) {
        int steps = GeneratorUtil.getBrewingSteps(level, PotionUtil.getUniquePotionName(stack), new HashSet<String>());
        double totalRF = 100.0 * Math.pow(4.0, steps);
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)(totalRF / generator.getGenerationRate())));
    }

    private static int getBrewingSteps(Level level, String potionOutputUid, Set<String> previousSteps) {
        GeneratorGalore.LOGGER.info("getBrewingSteps " + potionOutputUid + " prev:" + previousSteps.size());
        SetMultiMap<String, String> potionMap = PotionUtil.getPotionMap(level);
        Integer cachedBrewingSteps = PotionUtil.brewingStepCache.get(potionOutputUid);
        if (cachedBrewingSteps != null) {
            return cachedBrewingSteps;
        }
        if (!previousSteps.add(potionOutputUid)) {
            return Integer.MAX_VALUE;
        }
        Collection prevPotions = potionMap.get((Object)potionOutputUid);
        int minPrevSteps = prevPotions.stream().mapToInt(prevPotion -> GeneratorUtil.getBrewingSteps(level, prevPotion, previousSteps)).min().orElse(Integer.MAX_VALUE);
        int brewingSteps = minPrevSteps == Integer.MAX_VALUE ? Integer.MAX_VALUE : minPrevSteps + 1;
        PotionUtil.brewingStepCache.put(potionOutputUid, brewingSteps);
        return brewingSteps;
    }

    public static enum FuelType implements StringRepresentable
    {
        SOLID("SOLID"),
        FLUID("FLUID"),
        FOOD("FOOD"),
        ENCHANTMENT("ENCHANTMENT"),
        POTION("POTION");

        private final String key;
        public static StringRepresentable.EnumCodec<FuelType> CODEC;

        private FuelType(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FuelType::values);
        }
    }
}

