/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.GeneratorMenu;
import cy.jdkdigital.generatorgalore.common.datamap.FluidFuelMap;
import cy.jdkdigital.generatorgalore.common.datamap.SolidFuelMap;
import cy.jdkdigital.generatorgalore.init.ModTags;
import cy.jdkdigital.generatorgalore.util.GeneratorCreator;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GeneratorObject {
    private final ResourceLocation id;
    private Supplier<Block> blockSupplier;
    private Supplier<BlockEntityType<GeneratorBlockEntity>> blockEntityType;
    private Supplier<Item> upgradeSupplier;
    private Supplier<MenuType<GeneratorMenu>> menuType;
    private final GeneratorUtil.FuelType fuelType;
    private final double generationRate;
    private double modifiedGenerationRate = 0.0;
    private final double transferRate;
    private final double consumptionRate;
    private final int bufferCapacity;
    private final boolean hasChargeSlot;
    private final ResourceLocation fuelTag;
    private final boolean has8x;
    private final boolean has64x;
    private Map<ResourceLocation, GeneratorCreator.Fuel> fuelList;

    public GeneratorObject(ResourceLocation id, GeneratorUtil.FuelType fuelType, double generationRate, double transferRate, double consumptionRate, int bufferCapacity, boolean hasChargeSlot, ResourceLocation fuelTag, boolean has8x, boolean has64x) {
        this.id = id;
        this.fuelType = fuelType;
        this.generationRate = generationRate;
        this.transferRate = transferRate;
        this.consumptionRate = consumptionRate;
        this.bufferCapacity = bufferCapacity;
        this.hasChargeSlot = hasChargeSlot;
        this.fuelTag = fuelTag;
        this.has8x = has8x;
        this.has64x = has64x;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Supplier<Block> getBlockSupplier() {
        return this.blockSupplier;
    }

    public void setBlockSupplier(Supplier<Block> blockSupplier) {
        this.blockSupplier = blockSupplier;
    }

    public Supplier<BlockEntityType<GeneratorBlockEntity>> getBlockEntityType() {
        return this.blockEntityType;
    }

    public void setBlockEntityType(Supplier<BlockEntityType<GeneratorBlockEntity>> blockEntityType) {
        this.blockEntityType = blockEntityType;
    }

    public Supplier<Item> getUpgradeSupplier() {
        return this.upgradeSupplier;
    }

    public void setUpgradeSupplier(Supplier<Item> upgradeSupplier) {
        this.upgradeSupplier = upgradeSupplier;
    }

    public Supplier<MenuType<GeneratorMenu>> getMenuType() {
        return this.menuType;
    }

    public void setMenuType(Supplier<MenuType<GeneratorMenu>> menuType) {
        this.menuType = menuType;
    }

    public GeneratorUtil.FuelType getFuelType() {
        return this.fuelType;
    }

    public double getGenerationRate() {
        return this.modifiedGenerationRate > 0.0 ? this.modifiedGenerationRate : this.generationRate;
    }

    public void setGenerationRate(double generationRate) {
        this.modifiedGenerationRate = generationRate;
    }

    public double getOriginalGenerationRate() {
        return this.generationRate;
    }

    public double getTransferRate() {
        return this.transferRate;
    }

    public double getConsumptionRate() {
        return this.consumptionRate;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public boolean hasChargeSlot() {
        return this.hasChargeSlot;
    }

    public ResourceLocation getFuelTag() {
        return this.fuelTag;
    }

    public static Codec<GeneratorObject> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").orElse((Object)id).forGetter(GeneratorObject::getId), (App)GeneratorUtil.FuelType.CODEC.fieldOf("fuelType").orElse((Object)GeneratorUtil.FuelType.SOLID).forGetter(GeneratorObject::getFuelType), (App)Codec.DOUBLE.fieldOf("generationRate").forGetter(GeneratorObject::getOriginalGenerationRate), (App)Codec.DOUBLE.fieldOf("transferRate").forGetter(GeneratorObject::getTransferRate), (App)Codec.DOUBLE.fieldOf("consumptionRate").forGetter(GeneratorObject::getConsumptionRate), (App)Codec.INT.fieldOf("bufferCapacity").forGetter(GeneratorObject::getBufferCapacity), (App)Codec.BOOL.fieldOf("hasChargeSlot").orElse((Object)true).forGetter(GeneratorObject::hasChargeSlot), (App)ResourceLocation.CODEC.fieldOf("fuelTag").orElse((Object)GeneratorUtil.EMPTY_TAG).forGetter(GeneratorObject::getFuelTag), (App)Codec.BOOL.fieldOf("has8x").orElse((Object)true).forGetter(GeneratorObject::has8x), (App)Codec.BOOL.fieldOf("has64x").orElse((Object)true).forGetter(GeneratorObject::has64x)).apply((Applicative)instance, GeneratorObject::new));
    }

    public void setFuelList(Map<ResourceLocation, GeneratorCreator.Fuel> fuelList) {
        this.fuelList = fuelList;
    }

    public Map<ResourceLocation, GeneratorCreator.Fuel> getFuelList() {
        return this.fuelList;
    }

    public boolean has8x() {
        return this.has8x;
    }

    public boolean has64x() {
        return this.has64x;
    }

    public boolean isValidFuelItem(@NotNull ItemStack stack) {
        SolidFuelMap fuelData = (SolidFuelMap)this.getBlockSupplier().get().builtInRegistryHolder().getData(GeneratorGalore.SOLID_FUEL_MAP);
        if (fuelData != null) {
            return !fuelData.fuels().stream().filter(solidFuel -> solidFuel.item().test(stack)).toList().isEmpty();
        }
        if (!this.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG)) {
            return stack.is(ModTags.getItemTag(this.getFuelTag()));
        }
        if (this.getFuelType().equals((Object)GeneratorUtil.FuelType.FOOD)) {
            return stack.getItem().getFoodProperties(stack, null) != null;
        }
        if (this.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT)) {
            return !EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).isEmpty();
        }
        if (this.getFuelType().equals((Object)GeneratorUtil.FuelType.POTION)) {
            return stack.getItem() instanceof PotionItem;
        }
        if (this.getFuelList() != null) {
            return this.getFuelList().containsKey(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
        }
        return stack.getBurnTime(RecipeType.SMELTING) > 0;
    }

    public boolean isValidFuelFluid(FluidStack stack) {
        FluidFuelMap fuelData = (FluidFuelMap)this.getBlockSupplier().get().builtInRegistryHolder().getData(GeneratorGalore.FLUID_FUEL_MAP);
        if (fuelData != null) {
            return !fuelData.fuels().stream().filter(solidFuel -> solidFuel.fluid().test(stack)).toList().isEmpty();
        }
        if (!this.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG)) {
            return stack.getFluid().is(ModTags.getFluidTag(this.getFuelTag()));
        }
        return false;
    }

    public Pair<Float, Integer> getGenerationRateForItem(Level level, ItemStack fuelStack) {
        GeneratorCreator.Fuel fuel;
        SolidFuelMap fuelData = (SolidFuelMap)this.getBlockSupplier().get().builtInRegistryHolder().getData(GeneratorGalore.SOLID_FUEL_MAP);
        if (fuelData != null) {
            List<SolidFuelMap.SolidFuel> validFuels = fuelData.fuels().stream().filter(solidFuel -> solidFuel.item().test(fuelStack)).toList();
            return validFuels.isEmpty() ? new Pair((Object)Float.valueOf((float)this.getGenerationRate()), (Object)((int)((double)fuelStack.getBurnTime(RecipeType.SMELTING) * this.getConsumptionRate()))) : new Pair((Object)Float.valueOf(validFuels.getFirst().generationRate()), (Object)((int)((float)validFuels.getFirst().burnTime() * validFuels.getFirst().consumptionRate())));
        }
        Object rate = this.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT) ? GeneratorUtil.calculateEnchantmentGenerationRate(this, fuelStack) : (this.getFuelType().equals((Object)GeneratorUtil.FuelType.POTION) ? GeneratorUtil.calculatePotionGenerationRate(level, this, fuelStack) : (this.getFuelType().equals((Object)GeneratorUtil.FuelType.FOOD) ? GeneratorUtil.calculateFoodGenerationRate(this, fuelStack) : (this.getFuelList() != null ? new Pair((Object)Float.valueOf((fuel = this.getFuelList().get(BuiltInRegistries.ITEM.getKey((Object)fuelStack.getItem()))).rate() > 0.0f ? fuel.rate() : (float)this.getOriginalGenerationRate()), (Object)fuel.burnTime()) : new Pair((Object)Float.valueOf((float)this.getGenerationRate()), (Object)((int)((double)fuelStack.getBurnTime(RecipeType.SMELTING) * this.getConsumptionRate()))))));
        return rate;
    }

    public Pair<Double, Double> getGenerationRateForFluid(FluidStack fluidStack) {
        FluidFuelMap fuelData = (FluidFuelMap)this.getBlockSupplier().get().builtInRegistryHolder().getData(GeneratorGalore.FLUID_FUEL_MAP);
        if (fuelData != null) {
            List<FluidFuelMap.FluidFuel> validFuels = fuelData.fuels().stream().filter(solidFuel -> solidFuel.fluid().test(fluidStack)).toList();
            return validFuels.isEmpty() ? Pair.of((Object)this.getGenerationRate(), (Object)this.getConsumptionRate()) : Pair.of((Object)validFuels.getFirst().generationRate(), (Object)validFuels.getFirst().consumptionRate());
        }
        return Pair.of((Object)this.getGenerationRate(), (Object)this.getConsumptionRate());
    }
}

