/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.common.block.Generator;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.GeneratorMenu;
import cy.jdkdigital.generatorgalore.common.item.UpgradeItem;
import cy.jdkdigital.generatorgalore.init.ModBlockEntityTypes;
import cy.jdkdigital.generatorgalore.init.ModContainerTypes;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GeneratorCreator {
    public static GeneratorObject create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        Optional generatorOptional = GeneratorObject.codec(id).parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
        if (generatorOptional.isPresent()) {
            GeneratorObject generator = (GeneratorObject)generatorOptional.get();
            String name = String.format("%s_%s", generator.getId().getPath(), "generator");
            DeferredHolder generatorBlock = GeneratorGalore.BLOCKS.register(name, () -> new Generator(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE), generator, 1));
            generator.setBlockSupplier((Supplier<Block>)generatorBlock);
            ArrayList<DeferredHolder> generatorBlocks = new ArrayList<DeferredHolder>();
            generatorBlocks.add(generatorBlock);
            if (generator.has8x() || !FMLEnvironment.production) {
                DeferredHolder gen8x = GeneratorGalore.BLOCKS.register(name + "_8x", () -> new Generator(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE), generator, 8));
                generatorBlocks.add(gen8x);
                GeneratorGalore.ITEMS.register(name + "_8x", () -> GeneratorCreator.lambda$create$2((Supplier)gen8x));
            }
            if (generator.has64x() || !FMLEnvironment.production) {
                DeferredHolder gen64x = GeneratorGalore.BLOCKS.register(name + "_64x", () -> new Generator(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FURNACE), generator, 64));
                generatorBlocks.add(gen64x);
                GeneratorGalore.ITEMS.register(name + "_64x", () -> GeneratorCreator.lambda$create$4((Supplier)gen64x));
            }
            generator.setBlockEntityType(ModBlockEntityTypes.register(name, () -> ModBlockEntityTypes.createBlockEntityType((pos, state) -> new GeneratorBlockEntity(generator, pos, state), generatorBlocks.stream().map(Supplier::get).toList().toArray(new Block[0]))));
            generator.setMenuType(ModContainerTypes.register(name, GeneratorMenu::new));
            GeneratorGalore.ITEMS.register(name, () -> new BlockItem(generator.getBlockSupplier().get(), new Item.Properties()));
            if (json.has("previousTier")) {
                String previousTier = json.get("previousTier").getAsString();
                generator.setUpgradeSupplier((Supplier<Item>)GeneratorGalore.ITEMS.register(previousTier + "_to_" + generator.getId().getPath() + "_upgrade", () -> new UpgradeItem(new Item.Properties(), previousTier, generator)));
            }
            if (json.has("fuelList")) {
                generator.setFuelList(GeneratorCreator.parseFuelList(generator, json.get("fuelList")));
            }
            return generator;
        }
        GeneratorGalore.LOGGER.info("failed to read generator configuration for " + String.valueOf(id));
        return null;
    }

    private static Map<ResourceLocation, Fuel> parseFuelList(GeneratorObject generator, JsonElement fuelList) {
        HashMap<ResourceLocation, Fuel> fuels = new HashMap<ResourceLocation, Fuel>();
        for (JsonElement jsonElement : fuelList.getAsJsonArray()) {
            JsonObject el = jsonElement.getAsJsonObject();
            ResourceLocation id = ResourceLocation.parse((String)el.get("item").getAsString());
            fuels.put(id, new Fuel(el.has("rate") ? el.get("rate").getAsFloat() : (float)generator.getGenerationRate(), el.get("burnTime").getAsInt()));
        }
        return fuels;
    }

    private static /* synthetic */ BlockItem lambda$create$4(Supplier gen64x) {
        return new BlockItem((Block)gen64x.get(), new Item.Properties());
    }

    private static /* synthetic */ BlockItem lambda$create$2(Supplier gen8x) {
        return new BlockItem((Block)gen8x.get(), new Item.Properties());
    }

    public record Fuel(float rate, int burnTime) {
    }
}

