/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.data;

import cy.jdkdigital.generatorgalore.data.BlockTagProvider;
import cy.jdkdigital.generatorgalore.data.BlockstateProvider;
import cy.jdkdigital.generatorgalore.data.DataMapProvider;
import cy.jdkdigital.generatorgalore.data.LanguageProvider;
import cy.jdkdigital.generatorgalore.data.LootDataProvider;
import cy.jdkdigital.generatorgalore.data.RecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="generatorgalore", bus=EventBusSubscriber.Bus.MOD)
public class GeneratorGaloreDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockstateProvider(output, helper));
        gen.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(output, provider));
        BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
    }
}

