/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record SolidFuelRecipe(List<Ingredient> fuels, Ingredient generator, float rate, float consumptionRate) implements Recipe<RecipeInput>
{
    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(RecipeInput pContainer, HolderLookup.Provider registryAccess) {
        return null;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return null;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.SOLID_FUEL.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.SOLID_FUEL_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SolidFuelRecipe> {
        private static final MapCodec<SolidFuelRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.listOf().fieldOf("fuels").orElse(List.of()).forGetter(recipe -> recipe.fuels), (App)Ingredient.CODEC.fieldOf("generator").forGetter(recipe -> recipe.generator), (App)Codec.FLOAT.fieldOf("rate").forGetter(recipe -> Float.valueOf(recipe.rate)), (App)Codec.FLOAT.fieldOf("consumptionRate").forGetter(recipe -> Float.valueOf(recipe.consumptionRate))).apply((Applicative)builder, SolidFuelRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SolidFuelRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SolidFuelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SolidFuelRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static SolidFuelRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                ArrayList<Ingredient> fuels = new ArrayList<Ingredient>();
                IntStream.range(0, buffer.readInt()).forEach(i -> fuels.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
                return new SolidFuelRecipe(fuels, (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), buffer.readFloat(), buffer.readInt());
            }
            catch (Exception e) {
                GeneratorGalore.LOGGER.error("Error reading solid fuels recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, SolidFuelRecipe recipe) {
            try {
                buffer.writeInt(recipe.fuels().size());
                recipe.fuels().forEach(fuel -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, fuel));
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.generator());
                buffer.writeFloat(recipe.rate());
                buffer.writeFloat(recipe.consumptionRate());
            }
            catch (Exception e) {
                GeneratorGalore.LOGGER.error("Error writing solid fuels recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

