/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.container;

import cy.jdkdigital.generatorgalore.common.container.GeneratorMenu;
import cy.jdkdigital.generatorgalore.util.FluidContainerUtil;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GeneratorScreen
extends AbstractContainerScreen<GeneratorMenu> {
    private static final ResourceLocation GUI_SOLID = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"textures/gui/container/generator_solid.png");
    private static final ResourceLocation GUI_FLUID = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"textures/gui/container/generator_fluid.png");
    private static final ResourceLocation GUI_SOLID_CHARGING = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"textures/gui/container/generator_solid_charging.png");
    private static final ResourceLocation GUI_FLUID_CHARGING = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"textures/gui/container/generator_fluid_charging.png");

    public GeneratorScreen(GeneratorMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title.getString(), 8.0f, 6.0f, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle.getString(), 8.0f, (float)(this.getYSize() - 96 + 2), 0x404040, false);
        guiGraphics.drawString(this.font, Component.translatable((String)"generatorgalore.screen.generation_rate", (Object[])new Object[]{((GeneratorMenu)this.menu).blockEntity.getGenerationRate()}).getString(), ((GeneratorMenu)this.menu).blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) ? 51.0f : 8.0f, 24.0f, 0x404040, false);
        ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
        int energyAmount = ((GeneratorMenu)this.menu).blockEntity.energyHandler.getEnergyStored();
        if (this.isHovering(134, 16, 16, 54, mouseX, mouseY)) {
            tooltipList.add(Component.translatable((String)"generatorgalore.screen.energy_level", (Object[])new Object[]{energyAmount + "/" + ((GeneratorMenu)this.menu).blockEntity.energyHandler.getMaxEnergyStored() + "FE"}).getVisualOrderText());
        }
        if (((GeneratorMenu)this.menu).blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
            FluidStack fluidStack = ((GeneratorMenu)this.menu).blockEntity.fluidInventory.getFluidInTank(0);
            if (this.isHovering(26, 16, 16, 54, mouseX, mouseY)) {
                if (fluidStack.getAmount() > 0) {
                    tooltipList.add(Component.translatable((String)"generatorgalore.screen.fluid_level", (Object[])new Object[]{fluidStack.getHoverName().getString(), fluidStack.getAmount() + "mB"}).getVisualOrderText());
                } else {
                    tooltipList.add(Component.translatable((String)"generatorgalore.screen.empty").getVisualOrderText());
                }
            }
        }
        if (((GeneratorMenu)this.menu).blockEntity.isLit() && this.isHovering(81, 38, 13, 13, mouseX, mouseY)) {
            tooltipList.add(Component.translatable((String)"generatorgalore.screen.fuel_time", (Object[])new Object[]{((GeneratorMenu)this.menu).blockEntity.litTime}).getVisualOrderText());
        }
        guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        boolean canCharge = ((GeneratorMenu)this.menu).blockEntity.generator.hasChargeSlot();
        ResourceLocation GUI = ((GeneratorMenu)this.menu).blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) ? (canCharge ? GUI_FLUID_CHARGING : GUI_FLUID) : (canCharge ? GUI_SOLID_CHARGING : GUI_SOLID);
        guiGraphics.blit(GUI, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        if (((GeneratorMenu)this.menu).blockEntity.isLit()) {
            int progress = ((GeneratorMenu)this.menu).getLitProgress();
            guiGraphics.blit(GUI, this.getGuiLeft() + 81, this.getGuiTop() + 50 - progress, 176, 12 - progress, 14, progress);
        }
        int energyLevel = (int)((float)((GeneratorMenu)this.menu).blockEntity.energyHandler.getEnergyStored() * 54.0f / (float)((GeneratorMenu)this.menu).blockEntity.energyHandler.getMaxEnergyStored());
        guiGraphics.blit(GUI, this.getGuiLeft() + 134, this.getGuiTop() + 70 - energyLevel, 176, 70 - energyLevel, 16, energyLevel + 1);
        if (((GeneratorMenu)this.menu).blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) && (fluidStack = ((GeneratorMenu)this.menu).blockEntity.fluidInventory.getFluidInTank(0)).getAmount() > 0) {
            FluidContainerUtil.renderFluidTank(guiGraphics, this, fluidStack, ((GeneratorMenu)this.menu).blockEntity.fluidInventory.getTankCapacity(0), 26, 16, 16, 54, 100);
        }
    }
}

