/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class ParticleSmokeRing
extends Particle {
    private static final ResourceLocation beam = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");
    public String loc;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public float[] rgba = new float[4];
    public float rotation = 0.0f;
    public float sz = 0.2f;
    public boolean shaders = false;
    public int image;
    public float speed = 0.0f;
    public float radius = 0.0f;

    public ParticleSmokeRing(ClientLevel worldIn, Color color, double xCoordIn, double yCoordIn, double zCoordIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.bCol = 1.0f;
        this.alpha = 0.4f;
        float maxAge = 400.0f;
        this.lifetime = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.lifetime = (int)((float)this.lifetime);
        this.rgba[0] = (float)color.getRed() / 255.0f;
        this.rgba[1] = (float)color.getGreen() / 255.0f;
        this.rgba[2] = (float)color.getBlue() / 255.0f;
        this.rgba[3] = 1.0f;
        this.image = this.random.nextInt(6) + 1;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.oRoll = this.roll;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }

    public void render(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public static void renderSmokeRing(ParticleSmokeRing particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        float a;
        double d0 = particle.xo + (particle.x - particle.xo) * (double)partialTicks;
        double d1 = particle.yo + (particle.y - particle.yo) * (double)partialTicks;
        double d2 = particle.zo + (particle.z - particle.zo) * (double)partialTicks;
        matrix.pushPose();
        matrix.translate(d0 - d3, d1 - d4, d2 - d5);
        RenderUtils.rotateQ(particle.yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(particle.pitch, 1.0f, 0.0f, 0.0f, matrix);
        matrix.scale(particle.sz, particle.sz, particle.sz);
        float r = particle.rgba[0];
        float g = particle.rgba[1];
        float b = particle.rgba[2];
        particle.rgba[3] = a = 1.0f - (float)particle.age / (float)particle.lifetime;
        int j = 240;
        int k = 240;
        float xx = 0.5f;
        float bxx = -xx;
        float yy = 0.0f;
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        Matrix4f m = matrix.last().pose();
        RenderType ringType = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesRenderType(beam, 1));
        float realage = partialTicks + (float)particle.age;
        float progress = realage / (float)particle.lifetime;
        float alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - progress * 15.0f));
        float radius = 0.0f + ParticleSmokeRing.calculateSize(progress);
        float height = 0.4f + 0.7f * progress;
        if (alpha <= 1.0E-4f) {
            particle.age = particle.lifetime;
        }
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 0.0f, radius, height, MTConfig.SMOKE_RING_PARTICLE_QUALITY, j, k, r, g, b, alpha, ringType);
        matrix.popPose();
    }

    public static float calculateSize(float progress) {
        return 100.0f * progress - progress * progress * 200.0f;
    }
}

