/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.render.IEntityAwareRenderer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.Point;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.item.BookRender;
import stepsword.mahoutsukai.render.item.RuleBreakerRenderer;

public class WilliamRenderer
extends BlockEntityWithoutLevelRenderer
implements IClientItemExtensions,
IEntityAwareRenderer {
    public WilliamRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack matrix, MultiBufferSource buffer, int var1, int var2) {
        if (transform == ItemDisplayContext.GUI || transform == ItemDisplayContext.GROUND || transform == ItemDisplayContext.HEAD || transform == ItemDisplayContext.FIXED || transform == ItemDisplayContext.NONE) {
            this.render(null, stack, transform, matrix, buffer, var1, var2);
        }
    }

    @Override
    public void render(LivingEntity entity, ItemStack stack, ItemDisplayContext transform, PoseStack matrix, MultiBufferSource buffer, int var1, int var2) {
        matrix.pushPose();
        WilliamRenderer.renderBook(0.5, -0.2, 0.5, 0.0f, 180.0f, 0.0f, 1.0f, matrix, buffer, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        matrix.popPose();
    }

    public static void renderBook(double x, double y, double z, float yRot, float pRot, float dRot, float size, PoseStack matrix, MultiBufferSource buffer, float[] colors) {
        matrix.pushPose();
        matrix.translate(x, y, z);
        RenderUtils.rotateQ(dRot, 0.0f, 0.0f, 1.0f, matrix);
        RenderUtils.rotateQ(yRot, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pRot, 0.0f, 1.0f, 0.0f, matrix);
        int lx = 240;
        int ly = 240;
        matrix.scale(size, size, size);
        MultiBufferSource buf = buffer != null ? buffer : Minecraft.getInstance().renderBuffers().bufferSource();
        RenderType type = MahoujinRenderType.createRunesRenderType(RuleBreakerRenderer.white, 0);
        float[] rgba = new float[]{0.4f, 0.0f, 0.0f, 1.0f};
        float[] rgba2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        WilliamRenderer.renderFrontCover(type, new BookRender(), matrix, buf, rgba);
        WilliamRenderer.renderBackCover(type, new BookRender(), matrix, buf, rgba);
        WilliamRenderer.renderBinding(type, new BookRender(), matrix, buf, rgba);
        WilliamRenderer.renderFrontPageStack(type, new BookRender(), matrix, buf, rgba2);
        matrix.popPose();
    }

    public static void renderBackCover(RenderType type, BookRender br, PoseStack matrix, MultiBufferSource buffer, float[] colors) {
        int lx = 240;
        int ly = 240;
        Matrix4f m = matrix.last().pose();
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba);
        VertexConsumer buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.backCover, 0, darken).setColor(rgba[0], rgba[1], rgba[2], rgba[3]).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 5, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 6, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 7, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
        buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.backCover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
        buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.backCover, 4, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 5, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 7, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.backCover, 6, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
    }

    public static void renderFrontCover(RenderType type, BookRender br, PoseStack matrix, MultiBufferSource buffer, float[] colors) {
        int lx = 240;
        int ly = 240;
        Matrix4f m = matrix.last().pose();
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba);
        VertexConsumer buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.frontCover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 5, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 6, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 7, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
        buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.frontCover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
        buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.frontCover, 4, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 5, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 7, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.frontCover, 6, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
    }

    public static void renderBinding(RenderType type, BookRender br, PoseStack matrix, MultiBufferSource buffer, float[] colors) {
        int k;
        int lx = 240;
        int ly = 240;
        Matrix4f m = matrix.last().pose();
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba);
        float[] darken1 = BookRender.darken(rgba, 0.9f);
        float[] darken2 = BookRender.darken(darken, 0.9f);
        VertexConsumer buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.binding, 6, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 7, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 9 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 11 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
        buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.binding, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 5, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 8 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 10 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
        buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.binding, 4, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 6, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 8 + 4 * k, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 9 + 4 * k, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 0, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 2, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
        buf = buffer.getBuffer(type);
        Point.addPointAt(buf, m, br.binding, 5, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 7, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 10 + 4 * k, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 11 + 4 * k, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 1, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 3, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        RenderUtils.conditionalBatchEnder(type, buffer);
    }

    public static void renderFrontPageStack(RenderType type, BookRender br, PoseStack matrix, MultiBufferSource buffer, float[] colors) {
        int lx = 240;
        int ly = 240;
        Matrix4f m = matrix.last().pose();
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba);
        float[] darken2 = BookRender.darken(darken, 0.9f);
        for (int k = 0; k <= br.frontPageStack.size() - 8; k += 4) {
            VertexConsumer buf = buffer.getBuffer(type);
            Point.addPointAt(buf, m, br.frontPageStack, k, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 4, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 1, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 5, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 2, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 6, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 3, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 7, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.frontPageStack, k + 4, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            RenderUtils.conditionalBatchEnder(type, buffer);
        }
    }
}

