/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.item;

import java.util.ArrayList;
import java.util.Arrays;
import stepsword.mahoutsukai.render.Point;

public class BookRender {
    public float cover_width = 1.0f;
    public float cover_height = 1.4f;
    public float cover_thickness = 0.05f;
    public float cover_binding_max_curve = 0.5f;
    public float cover_binding_width = 0.3f;
    public float front_cover_open_angle = 0.0f;
    public float back_cover_open_angle = 0.0f;
    public double front_cover_angle_sin;
    public double front_cover_angle_cos;
    public double back_cover_angle_sin;
    public double back_cover_angle_cos;
    public double front_shifted_width_x;
    public double front_shifted_width_z;
    public double front_shifted_thickness_x;
    public double front_shifted_thickness_z;
    public double back_shifted_width_x;
    public double back_shifted_width_z;
    public double back_shifted_thickness_x;
    public double back_shifted_thickness_z;
    public int binding_quality = 10;
    public int page_stack_quality = 4;
    public float percentage_page_open = 0.8f;
    public float page_cover_border = 0.08f;
    public double page_width;
    public double page_height;
    public ArrayList<Point> frontCover;
    public ArrayList<Point> backCover;
    public ArrayList<Point> binding;
    public ArrayList<Point> frontPageStack;
    public ArrayList<Point> backPageStack;

    public BookRender() {
        this.calculatePoints();
    }

    public void calculatePoints() {
        this.front_cover_angle_sin = Math.sin(Math.toRadians(this.front_cover_open_angle));
        this.front_cover_angle_cos = Math.cos(Math.toRadians(this.front_cover_open_angle));
        this.back_cover_angle_sin = Math.sin(Math.toRadians(this.back_cover_open_angle));
        this.back_cover_angle_cos = Math.cos(Math.toRadians(this.back_cover_open_angle));
        this.front_shifted_width_x = (double)this.cover_width * this.front_cover_angle_cos;
        this.front_shifted_width_z = (double)(-this.cover_width) * this.front_cover_angle_sin;
        this.front_shifted_thickness_x = (double)this.cover_thickness * this.front_cover_angle_sin;
        this.front_shifted_thickness_z = (double)this.cover_thickness * this.front_cover_angle_cos;
        this.back_shifted_width_x = (double)this.cover_width * this.back_cover_angle_cos;
        this.back_shifted_width_z = (double)(-this.cover_width) * this.back_cover_angle_sin;
        this.back_shifted_thickness_x = (double)this.cover_thickness * this.back_cover_angle_sin;
        this.back_shifted_thickness_z = (double)this.cover_thickness * this.back_cover_angle_cos;
        this.frontCoverPoints();
        this.backCoverPoints();
        this.bindingPoints();
        this.frontPageStackPoints();
    }

    public void frontCoverPoints() {
        this.frontCover = new ArrayList();
        for (int i = 0; i < 8; ++i) {
            this.frontCover.add(Point.point());
        }
        for (int m : new int[]{2, 3, 6, 7}) {
            this.frontCover.get(m).shiftY(this.cover_height);
        }
        for (int m : new int[]{1, 2, 5, 6}) {
            this.frontCover.get(m).shiftX(-this.front_shifted_width_x).shiftZ(-this.front_shifted_width_z);
        }
        for (int m : new int[]{4, 5, 6, 7}) {
            this.frontCover.get(m).shiftX(-this.front_shifted_thickness_x).shiftZ(-this.front_shifted_thickness_z);
        }
        Object object = this.frontCover.iterator();
        while (object.hasNext()) {
            Point p = (Point)object.next();
            p.shiftX(-this.cover_binding_width / 2.0f);
        }
    }

    public void backCoverPoints() {
        this.backCover = new ArrayList();
        for (int i = 0; i < 8; ++i) {
            this.backCover.add(Point.point());
        }
        for (int m : new int[]{2, 3, 6, 7}) {
            this.backCover.get(m).shiftY(this.cover_height);
        }
        for (int m : new int[]{1, 2, 5, 6}) {
            this.backCover.get(m).shiftX(this.back_shifted_width_x).shiftZ(-this.back_shifted_width_z);
        }
        for (int m : new int[]{4, 5, 6, 7}) {
            this.backCover.get(m).shiftX(this.back_shifted_thickness_x).shiftZ(-this.back_shifted_thickness_z);
        }
        Object object = this.backCover.iterator();
        while (object.hasNext()) {
            Point p = (Point)object.next();
            p.shiftX(this.cover_binding_width / 2.0f);
        }
    }

    public void bindingPoints() {
        this.binding = new ArrayList();
        this.binding.addAll(Arrays.asList(this.frontCover.get(0), this.frontCover.get(4), this.frontCover.get(3), this.frontCover.get(7), this.backCover.get(0), this.backCover.get(4), this.backCover.get(3), this.backCover.get(7)));
        double theta = Math.toRadians(180.0f / (float)this.binding_quality);
        for (int k = 0; k <= this.binding_quality; ++k) {
            double sin = Math.sin(theta * (double)k);
            double cos = Math.cos(theta * (double)k);
            double inner_x = cos * (double)this.cover_binding_width / 2.0;
            double inner_z = -sin * (double)this.cover_binding_width / 2.0 * (double)this.cover_binding_max_curve;
            double outer_x = cos * (double)(this.cover_binding_width / 2.0f + this.cover_thickness);
            double outer_z = -sin * (double)(this.cover_binding_width / 2.0f + this.cover_thickness) * (double)this.cover_binding_max_curve;
            this.binding.add(Point.point().shiftX(inner_x).shiftZ(inner_z));
            this.binding.add(Point.point().shiftX(inner_x).shiftZ(inner_z).shiftY(this.cover_height));
            this.binding.add(Point.point().shiftX(outer_x).shiftZ(outer_z));
            this.binding.add(Point.point().shiftX(outer_x).shiftZ(outer_z).shiftY(this.cover_height));
        }
    }

    public void frontPageStackPoints() {
        this.frontPageStack = new ArrayList();
        for (int m = 0; m < this.page_stack_quality; ++m) {
            this.frontPageStack.addAll(Arrays.asList(Point.point(), Point.point(), Point.point(), Point.point()));
        }
        double last_angle = Math.toRadians((180.0f - this.back_cover_open_angle - this.front_cover_open_angle) * this.percentage_page_open);
        double one_q = last_angle / (double)((float)this.page_stack_quality * this.percentage_page_open);
        this.page_width = this.cover_width - this.page_cover_border;
        this.page_height = this.cover_height - this.page_cover_border * 2.0f;
        for (int k = 0; k < this.frontPageStack.size(); ++k) {
            double theta = (double)(-k) * one_q;
            double sinth = Math.sin(theta);
            double costh = Math.cos(theta);
            Point tmp = this.frontPageStack.get(k);
            tmp.shiftY(this.page_cover_border);
            if ((k - 1) % 4 == 0 || (k - 2) % 4 == 0) {
                // empty if block
            }
            if ((k - 2) % 4 != 0 && (k - 3) % 4 != 0) continue;
        }
    }

    public static float[] darken(float[] rgba) {
        float[] ret = new float[]{rgba[0] * 0.7f, rgba[1] * 0.7f, rgba[2] * 0.7f, rgba[3]};
        return ret;
    }

    public static float[] darken(float[] rgba, float z) {
        float[] ret = new float[]{rgba[0] * z, rgba[1] * z, rgba[2] * z, rgba[3]};
        return ret;
    }
}

