/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.networking.MahouPackets;

public class RipperUseEntityPacket
implements CustomPacketPayload {
    InteractionHand hand = InteractionHand.MAIN_HAND;
    int id = 0;
    public static final StreamCodec<ByteBuf, RipperUseEntityPacket> STREAM_CODEC = new StreamCodec<ByteBuf, RipperUseEntityPacket>(){

        public RipperUseEntityPacket decode(ByteBuf buf) {
            RipperUseEntityPacket packet = new RipperUseEntityPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, RipperUseEntityPacket packet) {
            packet.encode(buf);
        }
    };

    public RipperUseEntityPacket() {
    }

    public RipperUseEntityPacket(InteractionHand h, int i) {
        this.hand = h;
        this.id = i;
    }

    public void decode(ByteBuf buf) {
        this.id = buf.readInt();
        int h = buf.readInt();
        this.hand = h >= 0 && h < InteractionHand.values().length ? InteractionHand.values()[h] : InteractionHand.MAIN_HAND;
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.hand.ordinal());
    }

    public static void handle(RipperUseEntityPacket message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        if (player != null) {
            ServerLevel ServerLevel2 = (ServerLevel)player.level();
            Entity entity = ServerLevel2.getEntity(message.id);
            player.resetLastActionTime();
            if (entity instanceof LivingEntity) {
                boolean flag = BehaviorUtils.canSee((LivingEntity)player, (LivingEntity)((LivingEntity)entity));
                double d0 = 36.0;
                if (!flag) {
                    d0 = 9.0;
                }
                if (player.distanceToSqr(entity) < d0) {
                    if (entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow || entity == player) {
                        return;
                    }
                    TheRipper.attack((Player)player, entity);
                }
            }
        }
    }

    public CustomPacketPayload.Type<RipperUseEntityPacket> type() {
        return MahouPackets.RIPPER_USE_ENTITY_TYPE;
    }
}

