/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.networking.MahouPackets;

public class BakuretsuPacket
implements CustomPacketPayload {
    public double posX;
    public double posY;
    public double posZ;
    public int strength;
    public float motionX;
    public float motionY;
    public float motionZ;
    public static final StreamCodec<ByteBuf, BakuretsuPacket> STREAM_CODEC = new StreamCodec<ByteBuf, BakuretsuPacket>(){

        public BakuretsuPacket decode(ByteBuf buf) {
            BakuretsuPacket packet = new BakuretsuPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, BakuretsuPacket packet) {
            packet.encode(buf);
        }
    };

    public BakuretsuPacket() {
    }

    public BakuretsuPacket(double posX, double posY, double posZ, int strength, float motionX, float motionY, float motionZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.strength = strength;
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public void decode(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.strength = buf.readInt();
        this.motionX = buf.readFloat();
        this.motionY = buf.readFloat();
        this.motionZ = buf.readFloat();
    }

    public void encode(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.strength);
        buf.writeFloat(this.motionX);
        buf.writeFloat(this.motionY);
        buf.writeFloat(this.motionZ);
    }

    public static void handle(BakuretsuPacket message, IPayloadContext context) {
        ClientPacketHandler.handleBakuretsu(message);
    }

    public CustomPacketPayload.Type<BakuretsuPacket> type() {
        return MahouPackets.BAKURETSU_TYPE;
    }
}

