/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.william;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;

public class WrittenEvaluation {
    public static int bookEvaluation(ItemStack stack) {
        String s = WrittenEvaluation.getBookText(stack);
        return WrittenEvaluation.evaluateString(s);
    }

    public static int evaluateString(String s) {
        HashMap<String, Integer> countsOfWords = new HashMap<String, Integer>();
        HashMap<Character, Integer> countsOfChars = new HashMap<Character, Integer>();
        if (s.isEmpty()) {
            return 0;
        }
        StringBuilder currentWord = new StringBuilder();
        for (int p = 0; p < s.length(); ++p) {
            char c = s.charAt(p);
            if (Character.isWhitespace(c)) {
                String curr = currentWord.toString();
                if ((curr = WrittenEvaluation.trimPunct(curr)).isEmpty()) continue;
                countsOfWords.put(curr, countsOfWords.getOrDefault(curr, 0) + 1);
                currentWord = new StringBuilder();
                continue;
            }
            if (currentWord.isEmpty() && WrittenEvaluation.isPunct(s.substring(p, p + 1))) continue;
            currentWord.append(s.charAt(p));
            countsOfChars.put(Character.valueOf(c), countsOfChars.getOrDefault(Character.valueOf(c), 0) + 1);
        }
        return 0;
    }

    public static String trimPunct(String s) {
        int j;
        int i;
        for (i = 0; i < s.length() && WrittenEvaluation.isPunct(s.substring(i, i + 1)); ++i) {
        }
        for (j = s.length(); j >= 0 && WrittenEvaluation.isPunct(s.substring(j - 1, j)); --j) {
        }
        return s.substring(i, j);
    }

    public static boolean isPunct(String s) {
        return Pattern.matches("[\\p{Punct}\\p{IsPunctuation}]", s);
    }

    public static String getBookText(ItemStack stack) {
        int MAX_PAGES = 100;
        if (stack.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            WrittenBookContent writtenbookcontent = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
            List filtered = writtenbookcontent.getPages(true);
            List notfiltered = writtenbookcontent.getPages(false);
            StringBuilder bookText = new StringBuilder();
            for (int m = 0; m < MAX_PAGES && m < filtered.size(); ++m) {
                String s = ((Component)filtered.get(m)).getString();
                bookText.append(s).append("\n");
            }
            return bookText.toString();
        }
        return "";
    }

    public static int numChars(String s) {
        return 0;
    }

    public static int numWords(String s) {
        return s.split("/w").length;
    }

    public static int charsPerLine(String s) {
        return 0;
    }

    public static int wordsPerLine(String s) {
        return 0;
    }
}

