/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.handlers;

import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.capabilities.ModCapabilities;
import stepsword.mahoutsukai.creativetabs.ModTabs;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.entity.kodoku.KodokuEntity;
import stepsword.mahoutsukai.integration.apotheosis.ApotheosisLoadedProxy;
import stepsword.mahoutsukai.integration.apotheosis.ApotheosisProxy;
import stepsword.mahoutsukai.integration.gamestages.GameStagesLoadedProxy;
import stepsword.mahoutsukai.integration.gamestages.GameStagesProxy;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.tile.exchange.AlchemicalExchangeMahoujinTileEntity;

public class ServerHandlerModEventBus {
    @SubscribeEvent
    public void registerPackets(RegisterPayloadHandlersEvent event) {
        MahouPackets.register(event);
    }

    @SubscribeEvent
    public void onItemsRegistration(RegisterEvent event) {
        event.register(Registries.ITEM, helper -> {
            ModItems.register((RegisterEvent.RegisterHelper<Item>)helper);
            ModBlocks.registerItemBlocks((RegisterEvent.RegisterHelper<Item>)helper);
        });
    }

    @SubscribeEvent
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(ModCapabilities.MYSTIC_CODE, (stack, type) -> new ComponentItemHandler((MutableDataComponentHolder)stack, DataComponents.CONTAINER, 3), new ItemLike[]{(ItemLike)ModItems.mysticCode.get(), (ItemLike)ModItems.mysticCodeFirstSorcery.get()});
    }

    @SubscribeEvent
    public void onTabsAdd(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ModTabs.MAHOU_TAB.value()) {
            ModTabs.registerTabs(event);
            event.accept((ItemLike)ModBlocks.fogProjectorBlockItem);
            event.accept((ItemLike)ModBlocks.mahoujinProjectorBlockItem);
            event.accept((ItemLike)ModBlocks.spellClothBlockItem);
            event.accept((ItemLike)ModBlocks.manaCircuitBlockItem);
            event.accept((ItemLike)ModBlocks.manaCircuitMagitechBlockItem);
        }
    }

    @SubscribeEvent
    public void commonStartup(FMLCommonSetupEvent event) {
        MahoujinRecipeRegistrar.init();
        AlchemicalExchangeMahoujinTileEntity.init();
        MahouTsukaiMod.gamestages = ModList.get().isLoaded("gamestages") ? new GameStagesLoadedProxy() : new GameStagesProxy();
        MahouTsukaiMod.apotheosis = ModList.get().isLoaded("apotheosis") ? new ApotheosisLoadedProxy() : new ApotheosisProxy();
    }

    @SubscribeEvent
    public void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.FAE.get(), FaeEntity.registerAttributes().build());
        event.put((EntityType)ModEntities.FAMILIAR.get(), FamiliarEntity.registerAttributes().build());
        event.put((EntityType)ModEntities.KODOKU.get(), KodokuEntity.registerAttributes().build());
    }
}

