/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.events;

import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import net.acetheeldritchking.discerning_the_eldritch.items.weapons.IceSpearItem;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEPotionEffectRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.ItemRegistries;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;

@EventBusSubscriber
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerCastEvent(SpellPreCastEvent event) {
        ServerPlayer player;
        Player entity = event.getEntity();
        boolean hasSilenceEffect = entity.hasEffect(DTEPotionEffectRegistry.SILENCE_POTION_EFFECT);
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).level().isClientSide() && hasSilenceEffect) {
            event.setCanceled(true);
            int time = player.getEffect(DTEPotionEffectRegistry.SILENCE_POTION_EFFECT).getDuration();
            String formattedTime = ServerEvents.convertTicksToTime(time);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.literal((String)(String.valueOf(ChatFormatting.BOLD) + "Unable to cast for : " + formattedTime)).withStyle(s -> s.withColor(TextColor.fromRgb((int)0xF35F5F)))));
                serverPlayer.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public static String convertTicksToTime(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent.Post event) {
        LivingEntity livingEntity;
        ItemStack mainhandItem;
        Entity sourceEntity = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        Entity projectile = event.getSource().getDirectEntity();
        if (sourceEntity != null && sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            boolean hasCurio = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistries.DIARY_OF_DECAY.get(), (LivingEntity)player).isPresent();
            if (hasCurio && projectile instanceof Projectile) {
                target.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 0, true, true, true));
            }
        }
        if (sourceEntity instanceof LivingEntity && (mainhandItem = (livingEntity = (LivingEntity)sourceEntity).getMainHandItem()).getItem() instanceof IceSpearItem && target instanceof LivingEntity) {
            LivingEntity livingTarget = target;
            livingTarget.setTicksFrozen(400);
        }
    }

    @SubscribeEvent
    public static void livingIncomingDamageEvent(LivingIncomingDamageEvent event) {
        LivingEntity livingAttacker;
        LivingEntity livingTarget;
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (target instanceof LivingEntity && (livingTarget = target).hasEffect(DTEPotionEffectRegistry.METAPHYSICAL_POTION_EFFECT)) {
            event.setCanceled(true);
        }
        if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).hasEffect(DTEPotionEffectRegistry.METAPHYSICAL_POTION_EFFECT)) {
            event.setCanceled(true);
        }
    }
}

