/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.service;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nolijium.mixinextras.injector.LateInjectionApplicatorExtension;
import nolijium.mixinextras.injector.ModifyExpressionValueInjectionInfo;
import nolijium.mixinextras.injector.ModifyReceiverInjectionInfo;
import nolijium.mixinextras.injector.ModifyReturnValueInjectionInfo;
import nolijium.mixinextras.injector.WrapWithConditionV1InjectionInfo;
import nolijium.mixinextras.injector.v2.WrapWithConditionInjectionInfo;
import nolijium.mixinextras.injector.wrapmethod.WrapMethodApplicatorExtension;
import nolijium.mixinextras.injector.wrapmethod.WrapMethodInjectionInfo;
import nolijium.mixinextras.injector.wrapoperation.WrapOperationInjectionInfo;
import nolijium.mixinextras.lib.apache.commons.StringUtils;
import nolijium.mixinextras.service.MixinExtrasService;
import nolijium.mixinextras.service.MixinExtrasVersion;
import nolijium.mixinextras.service.ServiceInitializationExtension;
import nolijium.mixinextras.service.Versioned;
import nolijium.mixinextras.sugar.impl.SugarPostProcessingExtension;
import nolijium.mixinextras.sugar.impl.SugarWrapperInjectionInfo;
import nolijium.mixinextras.transformer.MixinTransformerExtension;
import nolijium.mixinextras.utils.MixinExtrasLogger;
import nolijium.mixinextras.utils.MixinInternals;
import nolijium.mixinextras.wrapper.factory.FactoryRedirectWrapperInjectionInfo;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;

public class MixinExtrasServiceImpl
implements MixinExtrasService {
    private static final MixinExtrasLogger LOGGER = MixinExtrasLogger.get("Service");
    private final List offeredPackages = new ArrayList();
    private final List offeredExtensions = new ArrayList();
    private final List offeredInjectors = new ArrayList();
    private final String ownPackage = StringUtils.substringBefore(this.getClass().getName(), ".service.");
    private final List allPackages = new ArrayList<Versioned>(Collections.singletonList(new Versioned(this.getVersion(), this.ownPackage)));
    private final List ownExtensions = Arrays.asList(new MixinTransformerExtension(), new ServiceInitializationExtension(this), new LateInjectionApplicatorExtension(), new SugarPostProcessingExtension(), new WrapMethodApplicatorExtension());
    private final List ownInjectors = Arrays.asList(ModifyExpressionValueInjectionInfo.class, ModifyReceiverInjectionInfo.class, ModifyReturnValueInjectionInfo.class, WrapOperationInjectionInfo.class, WrapWithConditionV1InjectionInfo.class);
    private final List ownGatedInjectors = Arrays.asList(new Versioned(MixinExtrasVersion.V0_3_4.getNumber(), WrapWithConditionInjectionInfo.class), new Versioned(MixinExtrasVersion.V0_4_0_BETA_1.getNumber(), WrapMethodInjectionInfo.class));
    private final List internalInjectors = Arrays.asList(SugarWrapperInjectionInfo.class, FactoryRedirectWrapperInjectionInfo.class);
    private final List registeredInjectors = new ArrayList();
    boolean initialized;

    @Override
    public int getVersion() {
        return MixinExtrasVersion.LATEST.getNumber();
    }

    @Override
    public boolean shouldReplace(Object object) {
        return this.getVersion() > MixinExtrasService.getFrom(object).getVersion();
    }

    @Override
    public void takeControlFrom(Object object) {
        LOGGER.debug("{} is taking over from {}", this, object);
        this.ownExtensions.forEach(iExtension -> {
            IExtension iExtension2 = iExtension;
            MixinInternals.registerExtension(iExtension2, iExtension2 instanceof ServiceInitializationExtension || iExtension instanceof MixinTransformerExtension);
        });
        this.ownInjectors.forEach(clazz -> this.registerInjector((Class)clazz, this.ownPackage));
        this.ownGatedInjectors.forEach(versioned -> this.registerInjector((Class)versioned.value, this.ownPackage));
    }

    @Override
    public void concedeTo(Object object, boolean bl) {
        this.requireNotInitialized();
        LOGGER.debug("{} is conceding to {}", this, object);
        object = MixinExtrasService.getFrom(object);
        if (bl) {
            this.deInitialize();
        }
        this.offeredPackages.forEach(arg_0 -> MixinExtrasServiceImpl.lambda$concedeTo$3((MixinExtrasService)object, arg_0));
        object.offerPackage(this.getVersion(), this.ownPackage);
        this.offeredExtensions.forEach(arg_0 -> MixinExtrasServiceImpl.lambda$concedeTo$4((MixinExtrasService)object, arg_0));
        this.ownExtensions.forEach(arg_0 -> this.lambda$concedeTo$5((MixinExtrasService)object, arg_0));
        this.offeredInjectors.forEach(arg_0 -> MixinExtrasServiceImpl.lambda$concedeTo$6((MixinExtrasService)object, arg_0));
        this.ownInjectors.forEach(arg_0 -> this.lambda$concedeTo$7((MixinExtrasService)object, arg_0));
    }

    @Override
    public void offerPackage(int n2, String string) {
        this.requireNotInitialized();
        this.offeredPackages.add(new Versioned(n2, string));
        this.allPackages.add(new Versioned(n2, string));
        this.ownInjectors.forEach(clazz -> this.registerInjector((Class)clazz, string));
        for (Versioned versioned : this.ownGatedInjectors) {
            if (n2 < versioned.version) continue;
            this.registerInjector((Class)versioned.value, string);
        }
    }

    @Override
    public void offerExtension(int n2, IExtension iExtension) {
        this.requireNotInitialized();
        this.offeredExtensions.add(new Versioned(n2, iExtension));
    }

    @Override
    public void offerInjector(int n2, Class clazz) {
        this.requireNotInitialized();
        this.offeredInjectors.add(new Versioned(n2, clazz));
    }

    public String toString() {
        return String.format("%s(version=%s)", new Object[]{this.getClass().getName(), MixinExtrasVersion.LATEST});
    }

    @Override
    public void initialize() {
        this.requireNotInitialized();
        LOGGER.info("Initializing MixinExtras via {}.", this);
        this.detectBetaPackages();
        this.internalInjectors.forEach(InjectionInfo::register);
        this.initialized = true;
    }

    private void deInitialize() {
        Iterator iterator = this.ownExtensions.iterator();
        while (iterator.hasNext()) {
            MixinInternals.unregisterExtension((IExtension)iterator.next());
        }
        this.registeredInjectors.forEach(MixinInternals::unregisterInjector);
    }

    private void registerInjector(Class clazz, String string) {
        String string2 = StringUtils.removeStart(clazz.getAnnotation(InjectionInfo.AnnotationType.class).value().getName(), this.ownPackage);
        this.registeredInjectors.add(string + string2);
        MixinInternals.registerInjector(string + string2, clazz);
    }

    public Type changePackage(Class clazz, Type object, Class object2) {
        object2 = StringUtils.substringAfter(((Class)object2).getName(), this.ownPackage);
        object = StringUtils.substringBefore(object.getClassName(), (String)object2);
        return Type.getObjectType((String)((String)object + StringUtils.substringAfter(clazz.getName(), this.ownPackage)).replace('.', '/'));
    }

    public Set getAllClassNames(String string) {
        return this.getAllClassNamesAtLeast(string, Integer.MIN_VALUE);
    }

    public Set getAllClassNamesAtLeast(String string, MixinExtrasVersion mixinExtrasVersion) {
        return this.getAllClassNamesAtLeast(string, mixinExtrasVersion.getNumber());
    }

    private Set getAllClassNamesAtLeast(String string, int n2) {
        string = string.replace('/', '.');
        return this.allPackages.stream().filter(versioned -> versioned.version >= n2).map(versioned -> (String)versioned.value).map(string2 -> StringUtils.replaceOnce(string, this.ownPackage, string2)).collect(Collectors.toSet());
    }

    public boolean isClassOwned(String string) {
        return this.allPackages.stream().map(versioned -> (String)versioned.value).anyMatch(string::startsWith);
    }

    private void requireNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("The MixinExtras service has already been selected and is initialized!");
        }
    }

    private void detectBetaPackages() {
        Iterator iterator = MixinInternals.getExtensions().getActiveExtensions().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = ((IExtension)iterator.next()).getClass().getName();
            if (!string.endsWith((String)(object = ".sugar.impl.SugarApplicatorExtension")) || this.isClassOwned(string)) continue;
            string = StringUtils.removeEnd(string, (String)object);
            object = this.getBetaVersion(string);
            this.allPackages.add(new Versioned(((MixinExtrasVersion)((Object)object)).getNumber(), string));
            LOGGER.warn("Found problematic active MixinExtras instance at {} (version {})", string, object);
            LOGGER.warn("Versions from 0.2.0-beta.1 to 0.2.0-beta.9 have limited support and it is strongly recommended to update.", new Object[0]);
        }
    }

    private MixinExtrasVersion getBetaVersion(String string) {
        Object object = string + ".MixinExtrasBootstrap";
        try {
            object = Class.forName((String)object).getDeclaredField("VERSION");
            ((AccessibleObject)object).setAccessible(true);
            object = (String)((Field)object).get(null);
            switch (object) {
                case "0.2.0-beta.1": {
                    return MixinExtrasVersion.V0_2_0_BETA_1;
                }
                case "0.2.0-beta.2": {
                    return MixinExtrasVersion.V0_2_0_BETA_2;
                }
                case "0.2.0-beta.3": {
                    return MixinExtrasVersion.V0_2_0_BETA_3;
                }
                case "0.2.0-beta.4": {
                    return MixinExtrasVersion.V0_2_0_BETA_4;
                }
                case "0.2.0-beta.5": {
                    return MixinExtrasVersion.V0_2_0_BETA_5;
                }
                case "0.2.0-beta.6": {
                    return MixinExtrasVersion.V0_2_0_BETA_6;
                }
                case "0.2.0-beta.7": {
                    return MixinExtrasVersion.V0_2_0_BETA_7;
                }
                case "0.2.0-beta.8": {
                    return MixinExtrasVersion.V0_2_0_BETA_8;
                }
                case "0.2.0-beta.9": {
                    return MixinExtrasVersion.V0_2_0_BETA_9;
                }
            }
            throw new IllegalArgumentException("Unrecognized version ".concat(String.valueOf(object)));
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to determine version of MixinExtras instance at %s, assuming 0.2.0-beta.1", string), exception);
            return MixinExtrasVersion.V0_2_0_BETA_1;
        }
    }

    private /* synthetic */ void lambda$concedeTo$7(MixinExtrasService mixinExtrasService, Class clazz) {
        mixinExtrasService.offerInjector(this.getVersion(), clazz);
    }

    private static /* synthetic */ void lambda$concedeTo$6(MixinExtrasService mixinExtrasService, Versioned versioned) {
        mixinExtrasService.offerInjector(versioned.version, (Class)versioned.value);
    }

    private /* synthetic */ void lambda$concedeTo$5(MixinExtrasService mixinExtrasService, IExtension iExtension) {
        mixinExtrasService.offerExtension(this.getVersion(), iExtension);
    }

    private static /* synthetic */ void lambda$concedeTo$4(MixinExtrasService mixinExtrasService, Versioned versioned) {
        mixinExtrasService.offerExtension(versioned.version, (IExtension)versioned.value);
    }

    private static /* synthetic */ void lambda$concedeTo$3(MixinExtrasService mixinExtrasService, Versioned versioned) {
        mixinExtrasService.offerPackage(versioned.version, (String)versioned.value);
    }
}

