/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.thevortex.potionsmaster.render.util.BlockInfo;
import org.joml.Matrix4f;

public class Util {
    public static float[] getComponents(int color) {
        float[] f = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return f;
    }

    public static void renderBlock(PoseStack stack, VertexConsumer buffer, BlockInfo blockinfo) {
        if (blockinfo == null) {
            return;
        }
        float size = 1.0f;
        float[] color = Util.getComponents(blockinfo.color);
        float red = color[0];
        float green = color[1];
        float blue = color[2];
        float opacity = 1.0f;
        float x = blockinfo.getX();
        float y = blockinfo.getY();
        float z = blockinfo.getZ();
        Matrix4f matrix4f = stack.last().pose();
        buffer.addVertex(matrix4f, x, y + 1.0f, z).setColor(red, green, blue, opacity);
        buffer.addVertex(matrix4f, x + 1.0f, y + 1.0f, z).setColor(red, green, blue, opacity);
        buffer.addVertex(matrix4f, x + 1.0f, y + 1.0f, z).setColor(red, green, blue, opacity);
        buffer.addVertex(matrix4f, x + 1.0f, y + 1.0f, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(matrix4f, x + 1.0f, y + 1.0f, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(matrix4f, x, y + 1.0f, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(matrix4f, x, y + 1.0f, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(matrix4f, x, y + 1.0f, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y + 1.0f, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x + 1.0f, y + 1.0f, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y + 1.0f, z + 1.0f).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y, z).setColor(red, green, blue, opacity);
        buffer.addVertex(x, y + 1.0f, z).setColor(red, green, blue, opacity);
    }
}

