/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.ServerPayloadContext;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorImpl
extends AccessorImpl<BlockHitResult>
implements BlockAccessor {
    private final BlockState blockState;
    @Nullable
    private final java.util.function.Supplier<BlockEntity> blockEntity;
    private ItemStack fakeBlock;

    private BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, Suppliers.ofInstance((Object)builder.hit), builder.connected, builder.showDetails);
        this.blockState = builder.blockState;
        this.blockEntity = builder.blockEntity;
        this.fakeBlock = builder.fakeBlock;
    }

    public static void handleRequest(RequestBlockPacket message, ServerPayloadContext context, Consumer<CompoundTag> responseSender) {
        ServerPlayer player = context.player();
        context.execute(() -> {
            BlockAccessor accessor = message.data().unpack(player);
            if (accessor == null) {
                return;
            }
            BlockPos pos = accessor.getPosition();
            ServerLevel world = player.serverLevel();
            double maxDistance = Mth.square((double)(player.blockInteractionRange() + 21.0));
            if (pos.distSqr((Vec3i)player.blockPosition()) > maxDistance || !world.isLoaded(pos)) {
                return;
            }
            List<IServerDataProvider<BlockAccessor>> providers = WailaCommonRegistration.instance().getBlockNBTProviders(accessor.getBlock(), accessor.getBlockEntity());
            CompoundTag tag = accessor.getServerData();
            for (IServerDataProvider<BlockAccessor> provider : providers) {
                if (!message.dataProviders().contains(provider)) continue;
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.putInt("x", pos.getX());
            tag.putInt("y", pos.getY());
            tag.putInt("z", pos.getZ());
            tag.putString("BlockId", CommonProxy.getId(accessor.getBlock()).toString());
            responseSender.accept(tag);
        });
    }

    @Override
    public Block getBlock() {
        return this.getBlockState().getBlock();
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this.blockEntity == null ? null : this.blockEntity.get();
    }

    @Override
    public BlockPos getPosition() {
        return ((BlockHitResult)this.getHitResult()).getBlockPos();
    }

    @Override
    public Direction getSide() {
        return ((BlockHitResult)this.getHitResult()).getDirection();
    }

    @Override
    public ItemStack getPickedResult() {
        return CommonProxy.getBlockPickedResult(this.blockState, this.getPlayer(), (BlockHitResult)this.getHitResult());
    }

    @Override
    @Nullable
    public Object getTarget() {
        return this.getBlockEntity();
    }

    @Override
    public boolean isFakeBlock() {
        return !this.fakeBlock.isEmpty();
    }

    @Override
    public ItemStack getFakeBlock() {
        return this.fakeBlock;
    }

    public void setFakeBlock(ItemStack fakeBlock) {
        this.fakeBlock = fakeBlock;
    }

    @Override
    public boolean verifyData(CompoundTag data) {
        if (!this.verify) {
            return true;
        }
        int x = data.getInt("x");
        int y = data.getInt("y");
        int z = data.getInt("z");
        BlockPos hitPos = this.getPosition();
        return x == hitPos.getX() && y == hitPos.getY() && z == hitPos.getZ();
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private Level level;
        private Player player;
        private CompoundTag serverData;
        private boolean connected;
        private boolean showDetails;
        private BlockHitResult hit;
        private BlockState blockState = Blocks.AIR.defaultBlockState();
        private java.util.function.Supplier<BlockEntity> blockEntity;
        private ItemStack fakeBlock = ItemStack.EMPTY;
        private boolean verify;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(BlockHitResult hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder blockState(BlockState blockState) {
            this.blockState = blockState;
            return this;
        }

        @Override
        public Builder blockEntity(java.util.function.Supplier<BlockEntity> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        @Override
        public Builder fakeBlock(ItemStack stack) {
            this.fakeBlock = stack;
            return this;
        }

        @Override
        public Builder from(BlockAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = (BlockHitResult)accessor.getHitResult();
            this.blockEntity = accessor::getBlockEntity;
            this.blockState = accessor.getBlockState();
            this.fakeBlock = accessor.getFakeBlock();
            return this;
        }

        @Override
        public BlockAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public BlockAccessor build() {
            BlockAccessorImpl accessor = new BlockAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }

    public record SyncData(boolean showDetails, BlockHitResult hit, BlockState blockState, ItemStack fakeBlock) {
        public static final StreamCodec<RegistryFriendlyByteBuf, SyncData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SyncData::showDetails, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeBlockHitResult, FriendlyByteBuf::readBlockHitResult), SyncData::hit, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), SyncData::blockState, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SyncData::fakeBlock, SyncData::new);

        public SyncData(BlockAccessor accessor) {
            this(accessor.showDetails(), (BlockHitResult)accessor.getHitResult(), accessor.getBlockState(), accessor.getFakeBlock());
        }

        public BlockAccessor unpack(ServerPlayer player) {
            Supplier blockEntity = null;
            if (this.blockState.hasBlockEntity()) {
                blockEntity = Suppliers.memoize(() -> player.level().getBlockEntity(this.hit.getBlockPos()));
            }
            return ((Builder)new Builder().level(player.level()).player((Player)player).showDetails(this.showDetails).hit(this.hit).blockState(this.blockState).blockEntity((java.util.function.Supplier)blockEntity)).fakeBlock(this.fakeBlock).build();
        }
    }
}

