/*
 * Decompiled with CFR 0.152.
 */
package fuzs.ytones;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.network.v3.NetworkHandler;
import fuzs.ytones.init.ModRegistry;
import fuzs.ytones.network.client.ServerboundCycleToneMessage;
import fuzs.ytones.world.level.block.Tone;
import fuzs.ytones.world.level.block.ToneType;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ytones
implements ModConstructor {
    public static final String MOD_ID = "ytones";
    public static final String MOD_NAME = "Ytones";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ytones");
    public static final NetworkHandler NETWORK = NetworkHandler.builder((String)"ytones").registerServerbound(ServerboundCycleToneMessage.class);

    public void onConstructMod() {
        ModRegistry.touch();
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icons(() -> {
            ArrayList items = Lists.newArrayList();
            ToneType type = ToneType.values()[0];
            for (Tone tone : Tone.values()) {
                items.add(new ItemStack((ItemLike)tone.block(type)));
            }
            return (ItemStack[])items.toArray(ItemStack[]::new);
        }).withSearchBar().displayItems((itemDisplayParameters, output) -> {
            output.accept((ItemLike)ModRegistry.FLAT_LAMP_ITEM.value());
            output.accept((ItemLike)ModRegistry.STONE_TILE_ITEM.value());
            Tone.forEach((tone, toneType) -> output.accept((ItemLike)tone.block((ToneType)((Object)((Object)toneType)))));
        }));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

