/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.varia.BlockPosTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public record TeleportDestination(GlobalPos pos, String name, boolean privateAccess, Set<String> allowedPlayers) {
    public static final TeleportDestination INVALID = new TeleportDestination(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), "", false, null);
    public static final Codec<TeleportDestination> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.optionalFieldOf("pos").forGetter(d -> Optional.ofNullable(d.pos)), (App)Codec.STRING.fieldOf("name").forGetter(d -> d.getName()), (App)Codec.BOOL.fieldOf("privateAccess").forGetter(TeleportDestination::isPrivateAccess), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("allowedPlayers").forGetter(d -> d.allowedPlayers == null ? Optional.empty() : Optional.of(new ArrayList<String>(d.allowedPlayers)))).apply((Applicative)instance, (pos, name, priv, players) -> new TeleportDestination(pos.orElse(null), (String)name, (boolean)priv, players.map(HashSet::new).orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportDestination> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), d -> Optional.ofNullable(d.pos), (StreamCodec)ByteBufCodecs.STRING_UTF8, d -> d.name, (StreamCodec)ByteBufCodecs.BOOL, d -> d.privateAccess, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list())), d -> d.allowedPlayers == null ? Optional.empty() : Optional.of(new ArrayList<String>(d.allowedPlayers)), (pos, name, priv, players) -> new TeleportDestination(pos.orElse(null), (String)name, (boolean)priv, players.map(HashSet::new).orElse(null)));

    public TeleportDestination(BlockPos coordinate, ResourceKey<Level> dimension) {
        this(GlobalPos.of(dimension, (BlockPos)coordinate), "", false, null);
    }

    public boolean isValid() {
        return BlockPosTools.isValid((BlockPos)this.pos.pos());
    }

    public String getName() {
        return this.name;
    }

    public TeleportDestination withName(String name) {
        return new TeleportDestination(this.pos, name == null ? "" : name, this.privateAccess, this.allowedPlayers);
    }

    public GlobalPos getPos() {
        return this.pos;
    }

    public BlockPos getCoordinate() {
        return this.pos.pos();
    }

    public ResourceKey<Level> getDimension() {
        return this.pos.dimension();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    @Nullable
    public Set<String> getAllowedPlayers() {
        return this.allowedPlayers;
    }

    public TeleportDestination withPrivateAccess(boolean privateAccess) {
        return new TeleportDestination(this.pos, this.name, privateAccess, this.allowedPlayers);
    }

    public boolean isAccessKnown() {
        return this.allowedPlayers != null;
    }

    public boolean checkAccess(Level level, UUID player) {
        if (!this.privateAccess) {
            return true;
        }
        ServerPlayer playerByUuid = level.getServer().getPlayerList().getPlayer(player);
        if (playerByUuid == null) {
            return true;
        }
        return this.allowedPlayers.contains(playerByUuid.getDisplayName().getString());
    }

    public TeleportDestination withAllowedPlayers(@Nullable Set<String> allowedPlayers) {
        return new TeleportDestination(this.pos, this.name, this.privateAccess, (Set<String>)(allowedPlayers == null ? null : new HashSet<String>(allowedPlayers)));
    }
}

