/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsutility.modules.screen.items.modules.InventoryModuleItem;
import mcjty.rftoolsutility.modules.screen.modules.InventoryScreenModule;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class InventoryClientScreenModule
implements IClientScreenModule<InventoryScreenModule.ModuleDataStacks> {
    public IClientScreenModule.TransformMode getTransformMode(ItemStack moduleItem) {
        return IClientScreenModule.TransformMode.ITEM;
    }

    public int getHeight(ItemStack moduleItem) {
        return 22;
    }

    public void render(GuiGraphics graphics, MultiBufferSource buffer, IModuleRenderHelper renderHelper, Font fontRenderer, int currenty, InventoryScreenModule.ModuleDataStacks screenData, ModuleRenderInfo renderInfo) {
        if (screenData == null) {
            return;
        }
        InventoryScreenModule data = InventoryModuleItem.data(renderInfo.moduleStack);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        float f3 = 0.0075f;
        float factor = renderInfo.factor;
        poseStack.translate(-0.5, 0.5, (double)0.06f);
        poseStack.scale(f3 * factor, -f3 * factor, 1.0E-4f);
        int x = 10;
        x = this.renderSlot(poseStack, buffer, currenty, screenData, data.getSlot1(), 0, x, renderInfo.getLightmapValue());
        x = this.renderSlot(poseStack, buffer, currenty, screenData, data.getSlot2(), 1, x, renderInfo.getLightmapValue());
        x = this.renderSlot(poseStack, buffer, currenty, screenData, data.getSlot3(), 2, x, renderInfo.getLightmapValue());
        this.renderSlot(poseStack, buffer, currenty, screenData, data.getSlot4(), 3, x, renderInfo.getLightmapValue());
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(-0.5f, 0.5f, 0.08f);
        poseStack.scale(f3 * factor, -f3 * factor, 1.0E-4f);
        x = 10;
        x = this.renderSlotOverlay(poseStack, buffer, fontRenderer, currenty, screenData, data.getSlot1(), 0, x, renderInfo.getLightmapValue());
        x = this.renderSlotOverlay(poseStack, buffer, fontRenderer, currenty, screenData, data.getSlot2(), 1, x, renderInfo.getLightmapValue());
        x = this.renderSlotOverlay(poseStack, buffer, fontRenderer, currenty, screenData, data.getSlot3(), 2, x, renderInfo.getLightmapValue());
        this.renderSlotOverlay(poseStack, buffer, fontRenderer, currenty, screenData, data.getSlot4(), 3, x, renderInfo.getLightmapValue());
        poseStack.popPose();
    }

    public void mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked) {
    }

    private int renderSlot(PoseStack matrixStack, MultiBufferSource buffer, int currenty, InventoryScreenModule.ModuleDataStacks screenData, int slot, int index, int x, int lightmapValue) {
        if (slot != -1) {
            ItemStack itm = ItemStack.EMPTY;
            try {
                itm = screenData.getStack(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!itm.isEmpty()) {
                matrixStack.pushPose();
                matrixStack.translate((float)x + 8.0f, (float)currenty + 8.0f, 0.0f);
                matrixStack.scale(16.0f, -16.0f, 16.0f);
                RenderHelper.renderItemGui((PoseStack)matrixStack, (MultiBufferSource)buffer, (ItemStack)itm, (int)lightmapValue, (int)OverlayTexture.NO_OVERLAY);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                ((MultiBufferSource.BufferSource)buffer).endBatch();
                matrixStack.popPose();
            }
            x += 30;
        }
        return x;
    }

    private int renderSlotOverlay(PoseStack matrixStack, MultiBufferSource buffer, Font fontRenderer, int currenty, InventoryScreenModule.ModuleDataStacks screenData, int slot, int index, int x, int lightmapValue) {
        if (slot != -1) {
            ItemStack itm = screenData.getStack(index);
            if (!itm.isEmpty()) {
                int size = itm.getCount();
                if (size > 1) {
                    Object s1 = size < 10000 ? String.valueOf(size) : (size < 1000000 ? size / 1000 + "k" : (size < 1000000000 ? size / 1000000 + "m" : size / 1000000000 + "g"));
                    RenderHelper.renderText((Font)fontRenderer, (String)s1, (int)(x + 19 - 2 - fontRenderer.width((String)s1)), (int)(currenty + 6 + 3), (int)0xFFFFFF, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightmapValue);
                }
                if (itm.getItem().isBarVisible(itm)) {
                    double health = itm.getItem().getBarWidth(itm);
                    int j1 = (int)Math.round(13.0 - health * 13.0);
                    int k = (int)Math.round(255.0 - health * 255.0);
                    VertexConsumer builder = buffer.getBuffer(CustomRenderTypes.QUADS_NOTEXTURE);
                    int r1 = 255 - k;
                    int g1 = k;
                    int b1 = 0;
                    int r2 = (255 - k) / 4;
                    int g2 = 63;
                    int b2 = 0;
                    InventoryClientScreenModule.renderQuad(builder, x + 2, currenty + 13, 13, 2, 0, 0, 0, 0.0f, 140);
                    InventoryClientScreenModule.renderQuad(builder, x + 2, currenty + 13, 12, 1, r2, g2, b2, 0.02f, 140);
                    InventoryClientScreenModule.renderQuad(builder, x + 2, currenty + 13, j1, 1, r1, g1, b1, 0.04f, 140);
                }
            }
            x += 30;
        }
        return x;
    }

    private static void renderQuad(VertexConsumer builder, int x, int y, int width, int height, int r, int g, int b, float offset, int lightmapValue) {
        builder.addVertex((float)x, (float)y, offset).setColor(r, g, b, 255).setLight(lightmapValue);
        builder.addVertex((float)x, (float)(y + height), offset).setColor(r, g, b, 255).setLight(lightmapValue);
        builder.addVertex((float)(x + width), (float)(y + height), offset).setColor(r, g, b, 255).setLight(lightmapValue);
        builder.addVertex((float)(x + width), (float)y, offset).setColor(r, g, b, 255).setLight(lightmapValue);
    }

    public boolean needsServerData() {
        return true;
    }
}

