/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.tools;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class RedstoneChannels
extends AbstractWorldData<RedstoneChannels> {
    private static final String REDSTONE_CHANNELS_NAME = "RfToolsRedstoneChannels";
    private int lastId = 0;
    private final Map<Integer, RedstoneChannel> channels = new HashMap<Integer, RedstoneChannel>();

    public static RedstoneChannels getChannels(Level world) {
        return (RedstoneChannels)RedstoneChannels.getData((Level)world, RedstoneChannels::new, RedstoneChannels::new, (String)REDSTONE_CHANNELS_NAME);
    }

    public RedstoneChannels() {
    }

    public RedstoneChannels(CompoundTag tagCompound) {
        ListTag lst = tagCompound.getList("channels", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.getCompound(i);
            int channel = tc.getInt("channel");
            int v = tc.getInt("value");
            String name = tc.getString("name");
            RedstoneChannel value = new RedstoneChannel();
            value.value = v;
            value.setName(name);
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.getInt("lastId");
    }

    public RedstoneChannel getOrCreateChannel(int id) {
        RedstoneChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new RedstoneChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public RedstoneChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        ListTag lst = new ListTag();
        for (Map.Entry<Integer, RedstoneChannel> entry : this.channels.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.putInt("channel", entry.getKey().intValue());
            tc.putInt("value", entry.getValue().getValue());
            tc.putString("name", entry.getValue().getName());
            lst.add((Object)tc);
        }
        tagCompound.put("channels", (Tag)lst);
        tagCompound.putInt("lastId", this.lastId);
        return tagCompound;
    }

    public static class RedstoneChannel {
        private int value = 0;
        private String name = "";

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

