/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.data.TimerData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TimerTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    private final LogicSupport support = new LogicSupport();
    private boolean prevIn = false;
    private int timer = 0;
    @GuiValue
    public static final Value<TimerTileEntity, Integer> VALUE_DELAY = Value.create((String)"delay", (Type)Type.INTEGER, TimerTileEntity::getDelay, TimerTileEntity::setDelay);
    @GuiValue(name="pauses")
    public static final Value<TimerTileEntity, Boolean> VALUE_PAUSES = Value.create((String)"pauses", (Type)Type.BOOLEAN, TimerTileEntity::isRedstonePauses, TimerTileEntity::setRedstonePauses);
    @Cap(type=CapType.CONTAINER)
    private static final Function<TimerTileEntity, MenuProvider> screenHandler = be -> new DefaultContainerProvider("Timer").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_TIMER, (GenericTileEntity)be)).setupSync((GenericTileEntity)be);

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/timer")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(TimerTileEntity::new));
    }

    public TimerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LogicBlockModule.TIMER.be().get(), pos, state);
    }

    public int getTimer() {
        return this.timer;
    }

    protected void tickServer() {
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_3;
    }

    public int getDelay() {
        TimerData data = (TimerData)this.getData(LogicBlockModule.TIMER_DATA);
        return data.delay();
    }

    public void setDelay(int delay) {
        TimerData data = (TimerData)this.getData(LogicBlockModule.TIMER_DATA);
        data = data.withDelay(delay);
        this.setData(LogicBlockModule.TIMER_DATA, data);
    }

    public boolean isRedstonePauses() {
        TimerData data = (TimerData)this.getData(LogicBlockModule.TIMER_DATA);
        return data.redstonePauses();
    }

    public void setRedstonePauses(boolean redstonePauses) {
        TimerData data = (TimerData)this.getData(LogicBlockModule.TIMER_DATA);
        data = data.withRedstonePauses(redstonePauses);
        this.setData(LogicBlockModule.TIMER_DATA, data);
    }

    public void tickOnServer() {
        int newout;
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        this.setChanged();
        TimerData data = (TimerData)this.getData(LogicBlockModule.TIMER_DATA);
        if (pulse) {
            this.timer = data.delay();
        }
        if (!data.redstonePauses() || !this.prevIn) {
            --this.timer;
        }
        if (this.timer <= 0) {
            this.timer = data.delay();
            newout = 15;
        } else {
            newout = 0;
        }
        this.support.setRedstoneState((GenericTileEntity)this, newout);
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.support.setPowerOutput(tag.getBoolean("rs") ? 15 : 0);
        this.prevIn = tag.getBoolean("prevIn");
        this.timer = tag.getInt("timer");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("rs", this.support.getPowerOutput() > 0);
        tag.putBoolean("prevIn", this.prevIn);
        tag.putInt("timer", this.timer);
    }
}

