/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.data.SequencerData;
import mcjty.rftoolsutility.modules.logic.tools.SequencerMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SequencerTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    private final LogicSupport support = new LogicSupport();
    private int currentStep = -1;
    public static final Key<Integer> PARAM_BIT = new Key("bit", Type.INTEGER);
    public static final Key<Boolean> PARAM_CHOICE = new Key("choice", Type.BOOLEAN);
    @GuiValue
    public static final Value<SequencerTileEntity, String> VALUE_MODE = Value.createEnum((String)"mode", (NamedEnum[])SequencerMode.values(), SequencerTileEntity::getMode, SequencerTileEntity::setMode);
    @GuiValue
    public static final Value<SequencerTileEntity, Boolean> VALUE_ENDSTATE = Value.create((String)"endstate", (Type)Type.BOOLEAN, SequencerTileEntity::getEndState, SequencerTileEntity::setEndState);
    @GuiValue
    public static final Value<SequencerTileEntity, Integer> VALUE_STEPCOUNT = Value.create((String)"stepcount", (Type)Type.INTEGER, SequencerTileEntity::getStepcount, SequencerTileEntity::setStepcount);
    @GuiValue
    public static final Value<SequencerTileEntity, Integer> VALUE_DELAY = Value.create((String)"delay", (Type)Type.INTEGER, SequencerTileEntity::getDelay, SequencerTileEntity::setDelay);
    private boolean prevIn = false;
    private int timer = 0;
    @Cap(type=CapType.CONTAINER)
    private static final Function<SequencerTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Sequencer").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_SEQUENCER, (GenericTileEntity)be)).data(LogicBlockModule.SEQUENCER_DATA, SequencerData.STREAM_CODEC, SequencerData.CODEC).setupSync((GenericTileEntity)be);
    @ServerCommand
    public static final Command<?> CMD_FLIPBITS = Command.create((String)"sequencer.flipBits", (te, player, params) -> te.flipCycleBits());
    @ServerCommand
    public static final Command<?> CMD_CLEARBITS = Command.create((String)"sequencer.clearBits", (te, player, params) -> te.clearCycleBits());
    @ServerCommand
    public static final Command<?> CMD_SETBIT = Command.create((String)"sequencer.setBit", (te, player, params) -> te.setCycleBit((Integer)params.get(PARAM_BIT), (Boolean)params.get(PARAM_CHOICE)));

    public boolean getEndState() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        return data.endstate();
    }

    public void setEndState(boolean endstate) {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        data = data.withEndstate(endstate);
        this.setData(LogicBlockModule.SEQUENCER_DATA, data);
    }

    public int getStepcount() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        return data.stepcount();
    }

    public void setStepcount(int stepcount) {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        data = data.withStepcount(stepcount);
        this.setData(LogicBlockModule.SEQUENCER_DATA, data);
    }

    public int getDelay() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        return data.delay();
    }

    public void setDelay(int delay) {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        data = data.withDelay(delay);
        this.setData(LogicBlockModule.SEQUENCER_DATA, data);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/sequencer")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(SequencerTileEntity::new));
    }

    public SequencerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LogicBlockModule.SEQUENCER.be().get(), pos, state);
    }

    public void checkRedstone(Level world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public SequencerMode getMode() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        return data.sequencerMode();
    }

    public void setMode(SequencerMode mode) {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        data = data.withSequencerMode(mode);
        this.setData(LogicBlockModule.SEQUENCER_DATA, data);
        switch (mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: 
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                this.currentStep = -1;
                break;
            }
            case MODE_LOOP1: 
            case MODE_LOOP2: 
            case MODE_STEP: {
                this.currentStep = 0;
            }
        }
        this.setChanged();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public boolean getCycleBit(int bit) {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        return (data.bits() >> bit & 1L) == 1L;
    }

    public long getCycleBits() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        return data.bits();
    }

    public void setCycleBit(int bit, boolean flag) {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        long cycleBits = data.bits();
        cycleBits = flag ? (cycleBits |= 1L << bit) : (cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        data = data.withBits(cycleBits);
        this.setData(LogicBlockModule.SEQUENCER_DATA, data);
    }

    public void flipCycleBits() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        data = data.withBits(data.bits() ^ 0xFFFFFFFFFFFFFFFFL);
        this.setData(LogicBlockModule.SEQUENCER_DATA, data);
    }

    public void clearCycleBits() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        data = data.withBits(0L);
        this.setData(LogicBlockModule.SEQUENCER_DATA, data);
    }

    protected void tickServer() {
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_4;
    }

    public void tickOnServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.handlePulse();
        }
        this.setChanged();
        --this.timer;
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        if (this.timer <= 0) {
            this.timer = data.delay();
            this.support.setRedstoneState((GenericTileEntity)this, this.checkOutput() ? 15 : 0);
            this.handleCycle(this.powerLevel > 0);
        } else if (this.timer > data.delay()) {
            this.timer = data.delay();
        }
    }

    public boolean checkOutput() {
        return this.currentStep == -1 ? ((SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA)).endstate() : this.getCycleBit(this.currentStep);
    }

    private void handleCycle(boolean redstone) {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        switch (data.sequencerMode()) {
            case MODE_ONCE1: 
            case MODE_ONCE2: {
                if (this.currentStep == -1) break;
                this.nextStepAndStop();
                break;
            }
            case MODE_LOOP1: {
                this.nextStep();
                break;
            }
            case MODE_LOOP2: {
                this.nextStep();
                break;
            }
            case MODE_LOOP3: {
                if (!redstone) break;
                this.nextStep();
                break;
            }
            case MODE_LOOP4: {
                if (redstone) {
                    this.nextStep();
                    break;
                }
                this.currentStep = -1;
                break;
            }
        }
    }

    private void handlePulse() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        switch (data.sequencerMode()) {
            case MODE_ONCE1: {
                if (this.currentStep != -1) break;
                this.currentStep = 0;
                break;
            }
            case MODE_ONCE2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP1: {
                break;
            }
            case MODE_LOOP2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                break;
            }
            case MODE_STEP: {
                this.nextStep();
            }
        }
    }

    private void nextStep() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        ++this.currentStep;
        if (this.currentStep >= data.stepcount()) {
            this.currentStep = 0;
        }
    }

    private void nextStepAndStop() {
        SequencerData data = (SequencerData)this.getData(LogicBlockModule.SEQUENCER_DATA);
        ++this.currentStep;
        if (this.currentStep >= data.stepcount()) {
            this.currentStep = -1;
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.support.setPowerOutput(tag.getBoolean("rs") ? 15 : 0);
        this.currentStep = tag.getInt("step");
        this.prevIn = tag.getBoolean("prevIn");
        this.timer = tag.getInt("timer");
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("rs", this.support.getPowerOutput() > 0);
        tag.putInt("step", this.currentStep);
        tag.putBoolean("prevIn", this.prevIn);
        tag.putInt("timer", this.timer);
    }
}

