/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsutility.modules.crafter.data.CraftingRecipe;
import mcjty.rftoolsutility.modules.crafter.data.SpeedMode;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record CrafterData(List<ItemStack> ghostSlots, List<CraftingRecipe> recipes, SpeedMode speedMode) {
    public static final Codec<CrafterData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("ghostSlots").forGetter(CrafterData::ghostSlots), (App)CraftingRecipe.CODEC.listOf().fieldOf("recipes").forGetter(CrafterData::recipes), (App)SpeedMode.CODEC.fieldOf("speedMode").forGetter(CrafterData::speedMode)).apply((Applicative)instance, CrafterData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrafterData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, CrafterData::ghostSlots, (StreamCodec)CraftingRecipe.STREAM_CODEC.apply(ByteBufCodecs.list()), CrafterData::recipes, SpeedMode.STREAM_CODEC, CrafterData::speedMode, CrafterData::new);

    public static CrafterData createDefault() {
        return new CrafterData((List<ItemStack>)ItemStackList.create((int)30), new ArrayList<CraftingRecipe>(), SpeedMode.SLOW);
    }

    public CrafterData withGhostSlots(List<ItemStack> ghostSlots) {
        return new CrafterData(ghostSlots, this.recipes, this.speedMode);
    }

    public CrafterData withRecipes(List<CraftingRecipe> recipes) {
        return new CrafterData(this.ghostSlots, recipes, this.speedMode);
    }

    public CraftingRecipe getRecipeSafe(int index) {
        if (index < 0 || index >= this.recipes.size()) {
            return new CraftingRecipe();
        }
        return this.recipes.get(index);
    }

    public CrafterData setRecipeSafe(int index, CraftingRecipe recipe) {
        if (index < 0) {
            return this;
        }
        ArrayList<CraftingRecipe> newRecipes = new ArrayList<CraftingRecipe>(this.recipes);
        while (newRecipes.size() <= index) {
            newRecipes.add(new CraftingRecipe());
        }
        newRecipes.set(index, recipe);
        return new CrafterData(this.ghostSlots, newRecipes, this.speedMode);
    }

    public CrafterData withSpeedMode(SpeedMode speedMode) {
        return new CrafterData(this.ghostSlots, this.recipes, speedMode);
    }
}

