/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.compat;

import java.util.function.Function;
import mcjty.rftoolsbase.api.dimension.IDimensionInformation;
import mcjty.rftoolsbase.api.dimension.IDimensionManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;

public class RFToolsDimCompat {
    private static boolean registered = false;
    public static IDimensionManager dimensionManager = null;

    public static void register() {
        if (ModList.get().isLoaded("rftoolsdim")) {
            RFToolsDimCompat.registerInternal();
        }
    }

    private static void registerInternal() {
        if (registered) {
            return;
        }
        registered = true;
        InterModComms.sendTo((String)"rftoolsdim", (String)"getDimensionManager", GetDimensionManager::new);
    }

    public static int getPowerPercentage(Level world, ResourceLocation id) {
        if (dimensionManager != null) {
            IDimensionInformation data = dimensionManager.getDimensionInformation(world, id);
            if (data != null) {
                long maxEnergy = data.getMaxEnergy(world);
                if (maxEnergy <= 0L) {
                    return -1;
                }
                return (int)(data.getEnergy() * 100L / maxEnergy);
            }
            return -1;
        }
        return -1;
    }

    public static class GetDimensionManager
    implements Function<IDimensionManager, Void> {
        @Override
        public Void apply(IDimensionManager tm) {
            dimensionManager = tm;
            return null;
        }
    }
}

