/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.oritech;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class OritechRecipeCategory
implements IRecipeCategory<RecipeHolder<OritechRecipe>> {
    public static final ResourceLocation GUI_COMPONENTS = BasicMachineScreen.GUI_COMPONENTS;
    private final int offsetX = 23;
    private final int offsetY = 17;
    private final MachineBlockEntity screenProvider;
    private final RecipeType<RecipeHolder<OritechRecipe>> recipeType;
    private final IDrawable icon;
    private final IDrawable background;
    private final IJeiHelpers jeiHelpers;
    private final IGuiHelper guiHelper;
    private final Component title;
    private final List<ScreenProvider.GuiSlot> slots;
    private final InventorySlotAssignment slotOffsets;

    public OritechRecipeCategory(IJeiHelpers helpers, RecipeType<RecipeHolder<OritechRecipe>> recipeType, Class<? extends MachineBlockEntity> screenProviderSource, ItemLike machine) {
        this.jeiHelpers = helpers;
        this.guiHelper = helpers.getGuiHelper();
        this.recipeType = recipeType;
        this.background = this.guiHelper.createBlankDrawable(150, 66);
        this.icon = this.guiHelper.createDrawableItemStack(new ItemStack(machine));
        this.title = Component.translatable((String)("emi.category.oritech." + recipeType.getUid().getPath()));
        BlockState blockState = Blocks.STONE.defaultBlockState();
        if (machine instanceof Block) {
            Block blockItem = (Block)machine;
            blockState = blockItem.defaultBlockState();
        }
        BlockState finalBlockState = blockState;
        try {
            this.screenProvider = screenProviderSource.getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(new BlockPos(0, 0, 0), finalBlockState);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.slots = this.screenProvider.getGuiSlots();
        this.slotOffsets = this.screenProvider.getSlots();
    }

    public RecipeType<RecipeHolder<OritechRecipe>> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<OritechRecipe> recipeHolder, IFocusGroup focuses) {
        FluidStack fluidOutput;
        OritechRecipe recipe = (OritechRecipe)recipeHolder.value();
        List inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Ingredient input = (Ingredient)inputs.get(i);
            if (input.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.inputStart() + i);
            builder.addSlot(RecipeIngredientRole.INPUT, pos.x() - 23, pos.y() - 17).addIngredients(input);
        }
        List outputs = recipe.getResults();
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = (ItemStack)outputs.get(i);
            if (output.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.outputStart() + i);
            builder.addSlot(RecipeIngredientRole.OUTPUT, pos.x() - 23, pos.y() - 17).addItemStack(output);
        }
        FluidStack fluidInput = recipe.getFluidInput();
        if (fluidInput != null && fluidInput.getAmount() > 0L) {
            builder.addSlot(RecipeIngredientRole.INPUT, 10, 6).addFluidStack(fluidInput.getFluid(), fluidInput.getAmount()).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)new CustomFluidRender(fluidInput));
        }
        if ((fluidOutput = recipe.getFluidOutput()) != null && fluidOutput.getAmount() > 0L) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 6).addFluidStack(fluidOutput.getFluid(), fluidOutput.getAmount()).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)new CustomFluidRender(fluidOutput));
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<OritechRecipe> recipeHolder, IFocusGroup focuses) {
        OritechRecipe recipe = (OritechRecipe)recipeHolder.value();
        boolean isGenerating = this.screenProvider instanceof UpgradableGeneratorBlockEntity;
        if (isGenerating) {
            builder.addAnimatedRecipeFlame(recipe.getTime()).setPosition(53, 24);
        } else {
            builder.addAnimatedRecipeArrow(recipe.getTime()).setPosition(57, 24);
        }
        String duration = String.format("%.0f", Float.valueOf((float)recipe.getTime() / 20.0f));
        ITextWidget iTextWidget = builder.addText((FormattedText)Component.translatable((String)"emi.title.oritech.cookingtime", (Object[])new Object[]{duration, recipe.getTime()}), this.getWidth(), this.getHeight()).setShadow(true).setTextAlignment(HorizontalAlignment.CENTER).setColor(0xFFFFFF);
        int n = this.getHeight();
        Objects.requireNonNull(Minecraft.getInstance().font);
        iTextWidget.setPosition(0, n - 9);
    }

    public void draw(RecipeHolder<OritechRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        OritechRecipe recipe = (OritechRecipe)recipeHolder.value();
        List inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Ingredient input = (Ingredient)inputs.get(i);
            if (input.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.inputStart() + i);
            this.guiHelper.getSlotDrawable().draw(guiGraphics, pos.x() - 23 - 1, pos.y() - 17 - 1);
        }
        FluidStack fluidOutput = recipe.getFluidOutput();
        if (fluidOutput != null && fluidOutput.getAmount() > 0L) {
            this.drawFluid(guiGraphics, fluidOutput, 120, 6, 16, 50, mouseX, mouseY);
        }
        List outputs = recipe.getResults();
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = (ItemStack)outputs.get(i);
            if (output.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.outputStart() + i);
            this.guiHelper.getSlotDrawable().draw(guiGraphics, pos.x() - 23 - 1, pos.y() - 17 - 1);
        }
    }

    private void drawFluid(GuiGraphics guiGraphics, FluidStack fluidInput, int fluidX, int fluidY, int fluidWidth, int fluidMaxHeight, double mouseX, double mouseY) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidType)fluidInput.getFluid().getFluidType());
        ResourceLocation FLUID_TEXTURE = props.getStillTexture().withPrefix("textures/").withSuffix(".png");
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int color = IClientFluidTypeExtensions.of((Fluid)fluidInput.getFluid()).getTintColor();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)0.9f);
        this.guiHelper.drawableBuilder(FLUID_TEXTURE, 0, 0, 16, 50).setTextureSize(16, 16).build().draw(guiGraphics, 0, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        this.guiHelper.drawableBuilder(GUI_COMPONENTS, 48, 0, fluidWidth, fluidMaxHeight).setTextureSize(98, 96).build().draw(guiGraphics, fluidX, fluidY);
    }

    private class CustomFluidRender
    implements IIngredientRenderer<net.neoforged.neoforge.fluids.FluidStack> {
        private final FluidStack fluidInput;

        public CustomFluidRender(FluidStack fluidInput) {
            this.fluidInput = fluidInput;
        }

        public void render(GuiGraphics guiGraphics, net.neoforged.neoforge.fluids.FluidStack ingredient) {
            OritechRecipeCategory.this.drawFluid(guiGraphics, this.fluidInput, 0, 0, 16, 50, 0.0, 0.0);
        }

        public List<Component> getTooltip(net.neoforged.neoforge.fluids.FluidStack ingredient, TooltipFlag tooltipFlag) {
            return List.of(Component.literal((String)"Fluid: ").append((Component)Component.translatable((String)this.fluidInput.getFluid().getFluidType().getDescriptionId())), Component.literal((String)("Amount: " + this.fluidInput.getAmount())));
        }

        public int getWidth() {
            return 14;
        }

        public int getHeight() {
            return 50;
        }
    }
}

