/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.container.slots;

import ironfurnaces.items.ItemHeater;
import ironfurnaces.items.augments.ItemAugmentBlasting;
import ironfurnaces.items.augments.ItemAugmentSmoking;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class SlotIronFurnaceInputGenerator
extends Slot {
    BlockIronFurnaceTileBase te;

    public SlotIronFurnaceInputGenerator(BlockIronFurnaceTileBase te, int index, int x, int y) {
        super((Container)te, index, x, y);
        this.te = te;
    }

    public boolean mayPlace(ItemStack stack) {
        if (!this.te.getItem(3).isEmpty()) {
            if (this.te.getItem(3).getItem() instanceof ItemAugmentBlasting) {
                return this.te.hasGeneratorBlastingRecipe(stack);
            }
            if (this.te.getItem(3).getItem() instanceof ItemAugmentSmoking) {
                return BlockIronFurnaceTileBase.getSmokingBurn(stack) > 0;
            }
        }
        if (stack.getItem() instanceof ItemHeater) {
            return false;
        }
        return BlockIronFurnaceTileBase.isItemFuel(stack, RecipeType.SMELTING);
    }

    public boolean isActive() {
        return this.te.isGenerator() && this.te.getAugmentGUI() == 0;
    }
}

