/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.impl;

import java.util.LinkedList;
import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ApiList {
    private final List<DynamicCrosshairApi> apis = new LinkedList<DynamicCrosshairApi>();
    boolean finalized = false;

    public ApiList add(ItemStack itemStack) {
        if (itemStack != null) {
            this.add(ApiList.getNamespace(itemStack));
        }
        return this;
    }

    public ApiList add(BlockState blockState) {
        if (blockState != null) {
            this.add(ApiList.getNamespace(blockState));
        }
        return this;
    }

    public ApiList add(Entity entity) {
        if (entity != null) {
            this.add(ApiList.getNamespace(entity));
        }
        return this;
    }

    public ApiList add(String namespace) {
        DynamicCrosshairApi api;
        if (!"minecraft".equals(namespace) && DynamicCrosshairMod.apis.containsKey(namespace) && !this.apis.contains(api = DynamicCrosshairMod.apis.get(namespace))) {
            this.apis.add(api);
        }
        return this;
    }

    public List<DynamicCrosshairApi> get() {
        if (!this.finalized) {
            for (String namespace : DynamicCrosshairMod.alwaysCheckedApis) {
                this.apis.add(DynamicCrosshairMod.apis.get(namespace));
            }
            this.apis.add(DynamicCrosshairMod.vanillaApi);
            this.finalized = true;
        }
        return this.apis;
    }

    private static String getNamespace(ItemStack itemStack) {
        return BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace();
    }

    private static String getNamespace(BlockState blockState) {
        return BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).getNamespace();
    }

    private static String getNamespace(Entity entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).getNamespace();
    }
}

