/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.integration;

import com.klikli_dev.modonomicon.networking.OpenBookOnClientMessage;
import com.klikli_dev.modonomicon.platform.Services;
import com.klikli_dev.modonomicon.registry.DataComponentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class LecternIntegration {
    public static InteractionResult rightClick(Player player, Level pLevel, InteractionHand hand, BlockHitResult hit) {
        BlockPos pos = hit.getBlockPos();
        BlockState state = pLevel.getBlockState(pos);
        BlockEntity blockEntity = pLevel.getBlockEntity(pos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            return InteractionResult.PASS;
        }
        LecternBlockEntity lectern = (LecternBlockEntity)blockEntity;
        if (((Boolean)state.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            ServerPlayer serverPlayer;
            if (player.isShiftKeyDown()) {
                LecternIntegration.takeBook(player, lectern);
            } else if (!pLevel.isClientSide && player instanceof ServerPlayer && LecternIntegration.openBook(serverPlayer = (ServerPlayer)player, lectern.getBook())) {
                return InteractionResult.SUCCESS;
            }
        } else {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.get(DataComponentRegistry.BOOK_ID.get()) != null && LecternBlock.tryPlaceBook((LivingEntity)player, (Level)pLevel, (BlockPos)pos, (BlockState)state, (ItemStack)stack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean openBook(ServerPlayer player, ItemStack stack) {
        ResourceLocation bookId = (ResourceLocation)stack.get(DataComponentRegistry.BOOK_ID.get());
        if (bookId != null) {
            Services.NETWORK.sendTo(player, new OpenBookOnClientMessage(bookId));
            return true;
        }
        return false;
    }

    private static void takeBook(Player player, LecternBlockEntity lectern) {
        ItemStack stack = lectern.getBook();
        ResourceLocation bookId = (ResourceLocation)stack.get(DataComponentRegistry.BOOK_ID.get());
        if (bookId != null) {
            lectern.setBook(ItemStack.EMPTY);
            LecternBlock.resetBookState((Entity)player, (Level)lectern.getLevel(), (BlockPos)lectern.getBlockPos(), (BlockState)lectern.getBlockState(), (boolean)false);
            if (!player.getInventory().add(stack)) {
                player.drop(stack, false);
            }
        }
    }
}

