/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.book.entry.BookEntryScreen;
import com.klikli_dev.modonomicon.client.gui.book.entry.linkhandler.LinkHandler;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.ClickCommandLinkMessage;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class CommandLinkHandler
extends LinkHandler {
    public CommandLinkHandler(BookEntryScreen screen) {
        super(screen);
    }

    @Override
    public LinkHandler.ClickResult handleClick(@NotNull Style pStyle) {
        ClickEvent event = pStyle.getClickEvent();
        if (event == null) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        if (event.getAction() != ClickEvent.Action.RUN_COMMAND) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        if (!CommandLink.isCommandLink(event.getValue())) {
            return LinkHandler.ClickResult.UNHANDLED;
        }
        CommandLink link = CommandLink.from(this.book(), event.getValue());
        Book book = BookDataManager.get().getBook(link.bookId);
        if (link.commandId == null) {
            return LinkHandler.ClickResult.FAILURE;
        }
        BookCommand command = book.getCommand(link.commandId);
        if (BookUnlockStateManager.get().canRunFor(this.player(), command)) {
            Services.NETWORK.sendToServer(new ClickCommandLinkMessage(link.bookId, link.commandId));
            if (Minecraft.getInstance().getSingleplayerServer() == null) {
                BookUnlockStateManager.get().setRunFor(this.player(), command);
            }
        }
        return LinkHandler.ClickResult.SUCCESS;
    }
}

