/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.entry;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookLink;
import com.klikli_dev.modonomicon.book.CommandLink;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.fluid.FluidHolder;
import com.klikli_dev.modonomicon.platform.ClientServices;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public interface ContentRenderingScreen {
    default public Screen asScreen() {
        return (Screen)this;
    }

    public Book getBook();

    public BookContentEntry getEntry();

    public Font getFont();

    public int getTicksInBook();

    public int getBookLeft();

    public int getBookTop();

    public void setTooltipStack(ItemStack var1);

    public void setTooltipStack(FluidHolder var1);

    public boolean isHoveringItemLink();

    public void isHoveringItemLink(boolean var1);

    default public boolean isMouseInRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx;
        double my = absMy;
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    default public void renderItemStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.renderItem(stack, x, y);
        guiGraphics.renderItemDecorations(this.getFont(), stack, x, y);
        if (this.isMouseInRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    default public void renderItemStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<ItemStack> stacks) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, stacks, -1);
    }

    default public void renderItemStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<ItemStack> stacks, int countOverride) {
        List<ItemStack> filteredStacks = PageRendererRegistry.filterRenderableItemStacks(stacks);
        if (filteredStacks.size() > 0) {
            ItemStack currentStack = filteredStacks.get(this.getTicksInBook() / 20 % filteredStacks.size());
            this.renderItemStack(guiGraphics, x, y, mouseX, mouseY, countOverride > 0 ? currentStack.copyWithCount(countOverride) : currentStack);
        }
    }

    default public void renderIngredient(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.getItems()), -1);
    }

    default public void renderIngredient(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Ingredient ingr, int countOverride) {
        this.renderItemStacks(guiGraphics, x, y, mouseX, mouseY, Arrays.asList(ingr.getItems()), countOverride);
    }

    default public void renderFluidStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack) {
        this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, stack, 1000);
    }

    default public void renderFluidStack(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, FluidHolder stack, int capacity) {
        if (stack.isEmpty() || !PageRendererRegistry.isRenderable(stack)) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        ClientServices.FLUID.drawFluid(guiGraphics, 18, 18, stack, capacity);
        guiGraphics.pose().popPose();
        if (this.isMouseInRange(mouseX, mouseY, x, y, 18, 18)) {
            this.setTooltipStack(stack);
        }
    }

    default public void renderFluidStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks) {
        this.renderFluidStacks(guiGraphics, x, y, mouseX, mouseY, stacks, 1000);
    }

    default public void renderFluidStacks(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Collection<FluidHolder> stacks, int capacity) {
        List<FluidHolder> filteredStacks = PageRendererRegistry.filterRenderableFluidStacks(stacks);
        if (filteredStacks.size() > 0) {
            this.renderFluidStack(guiGraphics, x, y, mouseX, mouseY, filteredStacks.get(this.getTicksInBook() / 20 % filteredStacks.size()), capacity);
        }
    }

    default public void renderComponentHoverEffect(GuiGraphics guiGraphics, @Nullable Style style, int mouseX, int mouseY) {
        ClickEvent clickEvent;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
        Style newStyle = style;
        if (style != null && style.getHoverEvent() != null && style.getHoverEvent().getAction() == HoverEvent.Action.SHOW_TEXT && (clickEvent = style.getClickEvent()) != null) {
            Book book;
            Object link;
            if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE && BookLink.isBookLink(clickEvent.getValue())) {
                link = BookLink.from(this.getBook(), clickEvent.getValue());
                book = BookDataManager.get().getBook(((BookLink)link).bookId);
                if (((BookLink)link).entryId != null) {
                    BookEntry entry = book.getEntry(((BookLink)link).entryId);
                    Integer page = ((BookLink)link).pageNumber;
                    if (((BookLink)link).pageAnchor != null) {
                        page = entry.getPageNumberForAnchor(((BookLink)link).pageAnchor);
                    }
                    if (!BookUnlockStateManager.get().isUnlockedFor((Player)Minecraft.getInstance().player, entry)) {
                        oldComponent = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
                        MutableComponent newComponent = Component.translatable((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, Component.translatable((String)"modonomicon.gui.hover.book_entry_link_locked_info").withStyle(s -> s.withColor(16711701).withBold(Boolean.valueOf(true))).append("\n").append((Component)Component.translatable((String)"modonomicon.gui.hover.book_entry_link_locked_info.hint", (Object[])new Object[]{Component.translatable((String)entry.getCategory().getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))}).withStyle(s -> s.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)))});
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)newComponent));
                    } else if (page != null && !BookUnlockStateManager.get().isUnlockedFor((Player)Minecraft.getInstance().player, entry.getPages().get(page))) {
                        oldComponent = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
                        MutableComponent newComponent = Component.translatable((String)"modonomicon.gui.hover.book_link_locked", (Object[])new Object[]{oldComponent, Component.translatable((String)"modonomicon.gui.hover.book_page_link_locked_info").withStyle(s -> s.withColor(16711701).withBold(Boolean.valueOf(true))).append("\n").append((Component)Component.translatable((String)"modonomicon.gui.hover.book_page_link_locked_info.hint", (Object[])new Object[]{Component.translatable((String)entry.getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))), Component.translatable((String)entry.getCategory().getName()).withStyle(s -> s.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))}).withStyle(s -> s.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)))});
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)newComponent));
                    }
                }
            }
            if (clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND && CommandLink.isCommandLink(clickEvent.getValue())) {
                link = CommandLink.from(this.getBook(), clickEvent.getValue());
                book = BookDataManager.get().getBook(((CommandLink)link).bookId);
                if (((CommandLink)link).commandId != null) {
                    BookCommand command = book.getCommand(((CommandLink)link).commandId);
                    Component oldComponent = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
                    if (!BookUnlockStateManager.get().canRunFor((Player)Minecraft.getInstance().player, command)) {
                        MutableComponent hoverComponent = Component.translatable((String)"modonomicon.gui.hover.command_link.unavailable").withStyle(ChatFormatting.RED);
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverComponent));
                        oldComponent = hoverComponent;
                    }
                    if (Screen.hasShiftDown()) {
                        MutableComponent newComponent = oldComponent.copy().append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)command.getCommand()).withStyle(ChatFormatting.GRAY));
                        newStyle = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)newComponent));
                    }
                }
            }
        }
        if ((style = newStyle) != null && style.getHoverEvent() != null) {
            HoverEvent hoverevent = style.getHoverEvent();
            HoverEvent.ItemStackInfo hoverevent$itemstackinfo = (HoverEvent.ItemStackInfo)hoverevent.getValue(HoverEvent.Action.SHOW_ITEM);
            if (hoverevent$itemstackinfo != null) {
                if (style.getClickEvent() != null) {
                    this.isHoveringItemLink(true);
                }
                int backupWidth = this.asScreen().width;
                this.asScreen().width /= 2;
                guiGraphics.renderTooltip(this.getFont(), hoverevent$itemstackinfo.getItemStack(), mouseX, mouseY);
                this.asScreen().width = backupWidth;
                this.isHoveringItemLink(false);
            } else {
                HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo = (HoverEvent.EntityTooltipInfo)hoverevent.getValue(HoverEvent.Action.SHOW_ENTITY);
                if (hoverevent$entitytooltipinfo != null) {
                    if (Minecraft.getInstance().options.advancedItemTooltips) {
                        guiGraphics.renderComponentTooltip(this.getFont(), hoverevent$entitytooltipinfo.getTooltipLines(), mouseX, mouseY);
                    }
                } else {
                    Component component = (Component)hoverevent.getValue(HoverEvent.Action.SHOW_TEXT);
                    if (component != null) {
                        int width = this.asScreen().width / 2 - mouseX - 10;
                        guiGraphics.renderTooltip(this.getFont(), this.getFont().split((FormattedText)component, width), mouseX, mouseY);
                    }
                }
            }
        }
        guiGraphics.pose().popPose();
    }
}

